<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
        <h2>System Monitoring Configuration</h2>
        <!--<script>
            <![CDATA[
                  loadMonitorSetting();
                  ]]>
        </script>-->
        <fieldset id='tempFullDiv' style="border:0px solid white;width:70%; height:70%;">
            <xsl:variable name="logLevel">
                <xsl:value-of select="return/logLevel"/>
            </xsl:variable>
            <xsl:comment>
                <xsl:value-of select="$logLevel"/>
            </xsl:comment>
            <div id="formset">
                <form>
                    <fieldset>
                        <legend>Logging Settings</legend>
                        <div>
                            <label for="log">Log Level</label>
                            <select id="logLevelSettingCombo" tabindex="1">
                                <option>
                                    <xsl:attribute name="value">TRACE</xsl:attribute>
                                    <xsl:if test="$logLevel='TRACE'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    TRACE
                                </option>
                                <option>
                                    <xsl:attribute name="value">DEBUG</xsl:attribute>
                                    <xsl:if test="$logLevel='DEBUG'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    DEBUG
                                </option>
                                <option>
                                    <xsl:attribute name="value">INFO</xsl:attribute>
                                    <xsl:if test="$logLevel='INFO'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    INFO
                                </option>
                                <option>
                                    <xsl:attribute name="value">WARN</xsl:attribute>
                                    <xsl:if test="$logLevel='WARN'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    WARN
                                </option>
                                <option>
                                    <xsl:attribute name="value">ERROR</xsl:attribute>
                                    <xsl:if test="$logLevel='ERROR'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    ERROR
                                </option>
                                <option>
                                    <xsl:attribute name="value">FATAL</xsl:attribute>
                                    <xsl:if test="$logLevel='FATAL'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    FATAL
                                </option>
                                <option>
                                    <xsl:attribute name="value">OFF</xsl:attribute>
                                    <xsl:if test="$logLevel='OFF'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    OFF
                                </option>
                            </select>
                        </div>
                        <div>
                            <label for="log_p">Log Pattern</label>
                            <input tabindex="2">
                                <xsl:attribute name="id">logPatternField</xsl:attribute>
                                <xsl:attribute name="type">text</xsl:attribute>
                                <xsl:attribute name="size">50</xsl:attribute>
                                <xsl:attribute name="value">
                                    <xsl:value-of select="return/logPattern"/>
                                </xsl:attribute>
                            </input>

                        </div>
                        <div>
                            <label for="log_f">Log File</label>
                            <input tabindex="3">
                                <xsl:attribute name="id">logFile</xsl:attribute>
                                <xsl:attribute name="type">text</xsl:attribute>
                                <xsl:attribute name="size">50</xsl:attribute>
                                <xsl:attribute name="value">
                                    <xsl:value-of select="return/logFile"/>
                                </xsl:attribute>
                            </input>
                        </div>
                        <div class="buttonrow">
                            <input tabindex="4">
                                <xsl:attribute name="value">Update</xsl:attribute>
                                <xsl:attribute name="onclick">
                                    javascript:setLogPattern(document.getElementById('logLevelSettingCombo'),
                                    document.getElementById('logPatternField').value,document.getElementById('logFile').value);</xsl:attribute>
                                <xsl:attribute name="type">button</xsl:attribute>
                            </input>
                        </div>
                    </fieldset>
                </form>
                <xsl:call-template name="appenders"/>
                <xsl:call-template name="message_monitoring"/>
            </div>
        </fieldset>
    </xsl:template>
    <xsl:template name="message_monitoring">
        <form>
            <fieldset>
                <legend>Message Monitoring</legend>
                <div>
                    <label>Monitoring</label>
                    <select id="monitorSettingCombo" tabindex="5"></select>
                </div>
                <div class="buttonrow">
                    <input tabindex="6">
                        <xsl:attribute name="value">Update</xsl:attribute>
                        <xsl:attribute name="onclick">
                            javascript:setMonitoring(document.getElementById('monitorSettingCombo'));</xsl:attribute>
                        <xsl:attribute name="type">button</xsl:attribute>
                    </input>
                </div>
            </fieldset>
        </form>
    </xsl:template>
    <xsl:template name="appenders">
        <form>
            <fieldset>
                <legend>Configure Log4J Appenders</legend>
                <div>
                    <label for="log">Name</label>
                    <select id="appeanderNameSettingCombo">
                        <option>
                            <xsl:attribute name="value">ConsoleAppender</xsl:attribute>
                            Console Appender
                        </option>
                        <option>
                            <xsl:attribute name="value">MemoryAppender</xsl:attribute>
                            Memory Appender
                        </option>
                        <option>
                            <xsl:attribute name="value">DailyRolingFileAppender</xsl:attribute>
                            Daily Rolling File Appender
                        </option>
                    </select>
                </div>
                <div>
                    <label for="log_p">Log Pattern</label>
                    <input>
                        <xsl:attribute name="id">logPatternField</xsl:attribute>
                        <xsl:attribute name="type">text</xsl:attribute>
                        <xsl:attribute name="size">50</xsl:attribute>

                    </input>

                </div>
                <div>
                    <label for="log_f">Log File</label>
                    <input>
                        <xsl:attribute name="id">logFile</xsl:attribute>
                        <xsl:attribute name="type">text</xsl:attribute>
                        <xsl:attribute name="size">50</xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:value-of select="return/logFile"/>
                        </xsl:attribute>
                    </input>
                </div>
                <div class="buttonrow">
                    <input>
                        <xsl:attribute name="value">Update</xsl:attribute>
                        <xsl:attribute name="type">button</xsl:attribute>
                    </input>
                </div>
            </fieldset>
        </form>
    </xsl:template>
</xsl:stylesheet>