<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="ns:getTrustedServicesResponse"  xmlns:ns="http://org.apache.axis2/xsd">
        <fieldset style="border:none;">

            <div id="genericScenarioHeader"></div>

            <div>
                <h2>STS Configuration</h2>
            </div>

            <div id="formset">
                <form>
                    <fieldset>
                        <legend>Trusted Services</legend>
                        <xsl:choose>
                            <xsl:when test="return">
                                <table class="styledLeft">
                                    <thead>
                                        <tr>
                                            <th>Service Endpoint Address</th>
                                            <th>Certificate Alias</th>
                                        </tr>
                                    </thead>
                                    <xsl:for-each select="return">
                                        <tr>
                                            <td>
                                                <xsl:value-of select="serviceAddress"/>
                                            </td>
                                            <td>
                                                <xsl:value-of select="certAlias"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </xsl:when>
                            <xsl:otherwise>
                                <div><h4>Trusted services are not available.</h4></div>
                            </xsl:otherwise>
                        </xsl:choose>

                    </fieldset>
                </form>

                <form>
                    <fieldset>
                        <legend>Add new trusted service</legend>
                        <div>
                            <label>Endpoint Address</label>
                            <input type="text" id="endpointAddressId" size="50"/>
                        </div>
                        <div>
                            <label>Certificate Alias</label>
                            <select id="certAliasSelectBoxId"></select>
                        </div>
                        <div class="buttonrow">
                            <input>
                                <xsl:attribute name="type">button</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:addTrustedService(); return false;</xsl:attribute>
                                <xsl:attribute name="value">Apply</xsl:attribute>
                            </input>
                        </div>
                    </fieldset>
                </form>

                <!--<form>
                    <fieldset>
                        <legend>Proof Key Type</legend>
                        <div>
                            <label>Proof Key Type</label>
                            <select id="proofKeyTypeSelectBoxId"></select>
                        </div>
                        <div class="buttonrow">
                            <input>
                                <xsl:attribute name="type">button</xsl:attribute>
                                <xsl:attribute name="onclick">javascript:setProofKeyType(); return false;</xsl:attribute>
                                <xsl:attribute name="value">Apply</xsl:attribute>
                            </input>
                        </div>
                    </fieldset>
                </form>
-->
            </div>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>