<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="ns1:getOperationStatisticsResponse"
                  xmlns:ns1="http://org.apache.axis2/xsd">
	<fieldset style="border:none;">
        <div>
            <xsl:attribute name="id">listServiceParamHeader</xsl:attribute>
        </div>

        <div id="formset">
            <form>
                <fieldset>
                    <legend>Operation Statistics</legend>
                    <table class="styledLeft">
                        <!-- Only one return will be expected from back end -->
                        <xsl:for-each select="return">
                            <thead>
                                <tr>
                                    <th colspan="2">Operation Statistics</th>
                                </tr>
                            </thead>
                            <tr>
                                <td>
                                    <strong>Average Response Time</strong>
                                </td>
                                <td>
                                    <xsl:value-of select="format-number(avgResponseTime,'#.##')"/> ms
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Minimum Response Time</strong>
                                </td>
                                <td>
                                    <xsl:choose>
                                        <xsl:when test="minResponseTime=0">
                                            &lt; 1.00 ms
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of
                                                    select="format-number(minResponseTime,'0.00')"/>
                                            ms
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Maximum Response Time</strong>
                                </td>
                                <td>
                                    <xsl:value-of select="format-number(maxResponseTime,'0.00')"/> ms
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong>Total Request Count</strong>
                                </td>
                                <td>
                                    <xsl:value-of select="opRequestCount"/>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Total Response Count</strong>
                                </td>
                                <td>
                                    <xsl:value-of select="opResponseCount"/>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Total Fault Count</strong>
                                </td>
                                <td>
                                    <xsl:value-of select="opFaultCount"/>
                                </td>
                            </tr>

                        </xsl:for-each>
                    </table>
                </fieldset>
            </form>

            <form>
               <fieldset>
                   <legend>Operation Parameters</legend>
                   <div id="listOperationsParameters"></div>
               </fieldset>
            </form>
        </div>
	</fieldset>
    </xsl:template>
</xsl:stylesheet>
