<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
        <h4><a onclick="javascript:manageUsers(); return false;" href="#">Users</a>&#160;&gt;&#160;Role Management</h4>
    	<fieldset style="border:none;">
        <div id="formset">
			<table class="styled">
				<thead>
                    <tr>
                        <th>Role Name</th>
                        <th>Role Description</th>
                        <th>Action</th>
                    </tr>

                    </thead>
				<xsl:for-each select="return">
                    <xsl:variable name="role_value">
                        <xsl:value-of select="role"/>
                    </xsl:variable>
                    <xsl:variable name="apos">
                        <xsl:text>'</xsl:text>
                    </xsl:variable>
                    <xsl:variable name="r_apos">
                        <xsl:text>§</xsl:text>
                    </xsl:variable>
                    <xsl:variable name="user_role"><xsl:value-of select="translate($role_value,$apos,$r_apos)"/></xsl:variable>
                    <tr>
                        <td>
                            <xsl:value-of select="role"/>
                        </td>
                        <td>
                            <xsl:value-of select="description"/>
                        </td>
                        <td>
                                <nobr>
                                &#160;&#160;
                            <a href="#" id="cancel_link">
                                <xsl:attribute name="onClick">javascript:deleteRoleCompletely('<xsl:value-of select="$user_role"/>'); return false;</xsl:attribute>
                                <xsl:attribute name="title">Remove <xsl:value-of select="role"/> Role</xsl:attribute>
                                <xsl:attribute name="alt">Remove</xsl:attribute>
                                &#160;&#160;&#160;&#160;
                            </a>
                            </nobr>
                            </td>
                    </tr>
				</xsl:for-each>
			</table>
			<p>&#160;</p>
            <form>
                <fieldset>
                    <legend>Add Role</legend>
                    <div>
                        <label for="RoleName">Role Name<font color='red'>*</font></label><input type="text" id="roleName" tabindex="1" maxlength="15"/>
                    </div>
                    <div>
                        <label for="RoleName">Role Description</label><input type="text" id="roleDescription" tabindex="2" maxlength="50"/>
                    </div>
                    <div class="buttonrow">
                       <input type="button" onclick="addRole(document.getElementById('roleName'),document.getElementById('roleDescription'));return false;" value="Add" tabindex="3"/>
                    </div>
                </fieldset>
            </form>
        </div>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>
