<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="restartServer" xmlns="http://www.w3.org/1999/xhtml">
        <h2>Shutdown or Restart Server </h2>
        <div id="formset">
            <form action="#">
                <fieldset>
                    <legend>Shutdown your WSO2 WSAS instance</legend>
                    <p>
                        <a>
                            <xsl:attribute name="href">#</xsl:attribute>
                            <xsl:attribute name="style">cursor:pointer;</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:wso2.wsf.Util.shutdownServerGracefully();</xsl:attribute>
                            Graceful Shutdown
                        </a>
                    </p>
                    <p>
                         Stop accepting new requests, continue to process already received requests, and then shutdown the server.
                    </p>
                    <br/>
                    <p>
                        <a>
                            <xsl:attribute name="href">#</xsl:attribute>
                            <xsl:attribute name="style">cursor:pointer;</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:wso2.wsf.Util.shutdownServer();</xsl:attribute>
                            Forced Shutdown
                        </a>
                    </p>
                    <p>
                        Forcefully shutdown the server.
                    </p>
                </fieldset>
                <fieldset>
                    <legend>Restart your WSO2 WSAS instance</legend>
                    <p>
                        Server restart takes approximately 10 seconds. You will not be able to connect to the server during this period.
                    </p>
                    <p>
                        <a>
                            <xsl:attribute name="href">#</xsl:attribute>
                            <xsl:attribute name="style">cursor:pointer;</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:wso2.wsf.Util.restartServerGracefully();</xsl:attribute>
                            Graceful Restart
                        </a>
                    </p>
                    <p>
                        Stop accepting new requests, continue to process already received requests, and then restart the server.
                    </p>
                    <br/>
                    <p>
                        <a>
                            <xsl:attribute name="href">#</xsl:attribute>
                            <xsl:attribute name="style">cursor:pointer;</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:wso2.wsf.Util.restartServer();</xsl:attribute>
                            Immediate Restart
                        </a>
                    </p>
                    <p>
                        Discard any requests currently being processed and immediately restart server.
                    </p>
                </fieldset>
            </form>
        </div>
    </xsl:template>
</xsl:stylesheet>
