<!--
  ~ Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
  ~
  ~ Licensed under the Apache License, Version 2.0 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:param name="topLevelHeading">DefaultHeading</xsl:param>

    <xsl:template match="genericScenarioInitializer">

        <fieldset style="border:none;">

            <!--  Link header to be populated by java script -->
            <div id="genericScenarioHeader"></div>

            <div>
                <h2><xsl:value-of select="$topLevelHeading"/></h2>
            </div>

            <div id="formset">

                <div id="divAvailableCertifcateStores"></div>

                <div id="divButtonRawForGenericScenario"><xsl:call-template name="buttonRaw"/></div>
            </div>

        </fieldset>

    </xsl:template>

    <xsl:template name="buttonRaw">
        <div>
            <input>
                <xsl:attribute name="type">button</xsl:attribute>
                <xsl:attribute name="value">&lt;&#160;Back</xsl:attribute>
                <xsl:attribute name="onclick">javascript:rampartBackButton();return false;</xsl:attribute>
            </input>
            <input>
               <xsl:attribute name="type">button</xsl:attribute>
               <xsl:attribute name="value">Apply</xsl:attribute>
               <xsl:attribute name="onclick">javascript:assignKeyStores();return false;</xsl:attribute>
            </input>
        </div>
    </xsl:template>

    <xsl:template match="ns1:getServiceKeyStoresResponse" xmlns:ns1="http://org.apache.axis2/xsd">

        <form>
            <fieldset>
                <legend>Trusted Certificate Stores</legend>
                <xsl:choose>
                    <xsl:when test="return">
                        <xsl:for-each select="return">
                            <span>
                                <input>
                                    <xsl:variable name="isChecked"><xsl:value-of select="selected" /></xsl:variable>
                                    <xsl:attribute name="name">trustedCertificateStoreNames</xsl:attribute>
                                    <xsl:attribute name="type">checkbox</xsl:attribute>
                                    <xsl:attribute name="value"><xsl:value-of select="keyStoreName"/></xsl:attribute>
                                    <xsl:if test="$isChecked='true'">
                                        <xsl:attribute name="checked">true</xsl:attribute>
                                    </xsl:if>
                                </input>
                                <xsl:value-of select="keyStoreName"/>&#160;[<xsl:value-of select="keyStoreType"/>]
                                <br/>
                            </span>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <div>
                            <p>Problem encountered while displaying trust stores</p>
                        </div>
                    </xsl:otherwise>
                </xsl:choose>
            </fieldset>
        </form>

        <form>
            <fieldset>
                <legend>Private Keystore</legend>
                <xsl:choose>
                    <xsl:when test="return">
                        <div>
                            <label>Private keystore</label>
                            <select id="privateKeystoreForServer">
                                <xsl:for-each select="return">
                                    <xsl:variable name="isprivateKeyStore"><xsl:value-of select="privateKeyStore" /></xsl:variable>
                                    <xsl:comment><xsl:value-of select="$isprivateKeyStore"/></xsl:comment>
                                    <option>
                                        <xsl:attribute name="value"><xsl:value-of select="keyStoreName"/></xsl:attribute>
                                        <xsl:if test="$isprivateKeyStore='true'">
                                            <xsl:attribute name="selected">true</xsl:attribute>
                                        </xsl:if>
                                        <xsl:value-of select="keyStoreName"/>
                                    </option>
                                </xsl:for-each>
                            </select>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <div><p>Problem encountered listing private keystores</p></div>
                    </xsl:otherwise>
                </xsl:choose>
            </fieldset>
        </form>
    </xsl:template>
</xsl:stylesheet>