<!--
  ~ Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
  ~
  ~ Licensed under the Apache License, Version 2.0 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:param name="topLevelHeading">DefaultHeading</xsl:param>

    <xsl:template match="ns1:getSecurityAssignmentResponse" xmlns:ns1="http://org.apache.axis2/xsd">

        <fieldset style="border:none;">

            <!--  Link header to be populated by java script -->
            <div id="listServiceUsersHeader"></div>

            <div>
                <h2>
                    <xsl:value-of select="$topLevelHeading"/>
                </h2>
            </div>

            <div id="formset">

                <form>
                    <fieldset>
                        <legend>Assign user to service</legend>
                       <!-- end of link header block -->
                            <xsl:choose>
                                <xsl:when test="//users">
                                    <xsl:for-each select="//users">
                                        <span>
                                            <input>
                                                <xsl:variable name="isSelected"><xsl:value-of select="selected" /></xsl:variable>
                                                <xsl:attribute name="name">assignUserToServiceName</xsl:attribute>
                                                <xsl:attribute name="type">checkbox</xsl:attribute>
                                                <xsl:attribute name="value"><xsl:value-of select="string"/></xsl:attribute>
                                                <xsl:if test="$isSelected='true'">
                                                    <xsl:attribute name="checked">true</xsl:attribute>
                                                </xsl:if>
                                            </input>
                                            <xsl:value-of select="string"/>&#160;
                                            <br/>
                                        </span>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:otherwise>
                                    <p>No users have been assigned to this service.</p>
                                    <p>&#160;</p>
                                </xsl:otherwise>
                            </xsl:choose>
                     </fieldset>
                 </form>

                <form>
                    <fieldset>
                        <legend>Assign user role to service</legend>
                       <!-- end of link header block -->
                        <xsl:choose>
                            <xsl:when test="//roles">
                                <xsl:for-each select="//roles">
                                    <span>
                                        <input>
                                            <xsl:variable name="isSelected"><xsl:value-of select="selected" /></xsl:variable>
                                            <xsl:attribute name="name">assignRoleToServiceName</xsl:attribute>
                                            <xsl:attribute name="type">checkbox</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="string"/></xsl:attribute>
                                            <xsl:if test="$isSelected='true'">
                                                <xsl:attribute name="checked">true</xsl:attribute>
                                            </xsl:if>
                                        </input>
                                        <xsl:value-of select="string"/>&#160;
                                        <br/>
                                    </span>
                              </xsl:for-each>

                            </xsl:when>
                            <xsl:otherwise>
                                <p>No roles have been assigned to this service.</p>
                                <p>&#160;</p>
                            </xsl:otherwise>
                        </xsl:choose>
                        <p>&#160;</p>
                       </fieldset>
                  </form>
            </div>

            <xsl:call-template name="buttonRawRolles"/>

        </fieldset>

    </xsl:template>


    <xsl:template name="buttonRawRolles">
        <div>
            <input>
                <xsl:attribute name="type">button</xsl:attribute>
                <xsl:attribute name="value">&lt;&#160;Back</xsl:attribute>
                <xsl:attribute name="onclick">javascript:rampartBackButton();return false;</xsl:attribute>
            </input>
            <input>
                <xsl:attribute name="type">button</xsl:attribute>
                <xsl:attribute name="value">Apply</xsl:attribute>
                <xsl:attribute name="onclick">javascript:assignUsersAndRoles();return false;</xsl:attribute>
           </input>

        </div>
    </xsl:template>


</xsl:stylesheet>