<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
        <!--  Link header to be populated by java script -->
        <div id="modulePoliciesEditHeader"></div>
        <!--<fieldset style="border:none;">-->
            <div id="operationConfigUpdate"></div>
            <xsl:choose>
                <xsl:when test="return">
                    <div id="formset">
                        <form>
                            <fieldset>
                                <legend>Module Policies</legend>
                                <xsl:for-each select="return">

                                        <xsl:variable name="textBoxId"><xsl:value-of select="position()"/>_module_policy_text_</xsl:variable>
                                         <div>
                                                 <table class='styled'>
                                                    <thead>
                                                        <tr>
                                                            <td>
                                                                <xsl:value-of select="wrapper"/>
                                                            </td>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <textarea cols="80" rows="10">
                                                                    <xsl:attribute name="id"><xsl:value-of select="$textBoxId"/> </xsl:attribute>
                                                                    <xsl:value-of select="polycies"/>
                                                                </textarea>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                               </table>
                                        </div>
                                        <div class="buttonrow">

                                                <!-- update button -->
                                                <input type="button" value="Update">
                                                    <xsl:attribute name="onClick">javascript:updateModulePolicy(lastUsedModuleId,
                                                                                                                lastUsedModuleVersion,
                                                                                                                document.getElementById('<xsl:value-of select="$textBoxId"/>').value);return false;
                                                    </xsl:attribute>
                                                </input>

                                        </div>

                                </xsl:for-each>
                            </fieldset>
                        </form>
                    </div>
                </xsl:when>

                <xsl:otherwise>
                    <div id="formset">
                        <form>
                            <fieldset>
                                <legend>Module Policies</legend>
                                <p>No module policies found.</p>
                            </fieldset>
                        </form>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
            
    </xsl:template>

</xsl:stylesheet>


