<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:param name="fp2"/>

    <xsl:template match="forgotPassword" xmlns="http://www.w3.org/1999/xhtml">
        <fieldset style='border: 0px;'>
            <div><!-- /container -->
                <xsl:choose>
                    <xsl:when test="not($fp2)">
                         <h4><a href="#" onclick="javascript:history.back(); return false;">Sign In</a>&#160;&gt;&#160;Forgot Password</h4>
                    </xsl:when>
                    <xsl:otherwise>
                         <h4><a href="#" onclick="javascript:history.back();history.back(); return false;">Sign In</a>&#160;&gt;&#160;<a href="#" onclick="javascript:history.back(); return false;">Help on Signing In</a>&#160;&gt;&#160;Forgot Password</h4>
                    </xsl:otherwise>
                </xsl:choose>
                <h2>Forgot @server_name@ Management Console password</h2>
                <dl style="margin: 1em;">
                    <dt><strong>Non Admin User</strong></dt>
                    <dd>Please contact the system Admin. The system administrator can reset the password of
                        any non
                        admin account.<br/><br/></dd>
                    <dt><strong>Admin User</strong></dt>

                    <dd>Due to security concerns, you cannot retrieve your password using this Admin
                        Console. You may change your
                        password by running the <b>chpasswd</b> script on the machine which is hosting the
                        @server_name@ server.<br/>
                        This script is located at <i>@server_short_name@_HOME/bin</i><br/><b>IMPORTANT:</b> Before
                        executing this script, you should shutdown the @server_short_name@ Server.
                        <br/><span>@chpassword.link.span@</span>
                    </dd>
                </dl>
            </div>
        </fieldset>
    </xsl:template>

    <xsl:template match="signInHelp" xmlns="http://www.w3.org/1999/xhtml">
        <fieldset style='border: 0px;'>
            <div id="noMenuContainer" style="display:inline;"><!-- content -->
                <h4><a href="#" onclick="javascript:history.back(); return false;">Sign In</a>&#160;&gt;&#160;Sign In Help</h4>
                <h2>Help on Signing In</h2>

                <p>
                    Following is a list of issues that you may face when Signing In and the reasons and
                    solutions to them.
                </p>
                <ol style="margin: 1em;">
                    <li><b>ERROR :: Could not connect to the server. Please try again in a moment</b>

                        <p>You can get this message when the @server_name@ server is down or when it can't
                            be reached on the network.</p>
                    </li>
                    <li><b>ERROR :: Login failed. Please recheck the user name and password and try
                        again</b>

                        <p>You can get this error even when you have spelt the user name and password
                            correctly, because
                            both user name and password are case sensitive, or due to the page being in an
                            inconsistent state.
                            Check whether the caps lock is on and whether you have spelt the user name and
                            the password correctly.
                            If the correct user name and the password is still failing then refresh the page
                            and try again.
                        </p>
                    </li>
                    <li><b>Forgot Password</b>
                        <p>Have a look at the <a href="#" onclick="javascript:showForgotPassword([['fp2','true']]); return false;">Forgot Password</a> page.</p>
                    </li>
                </ol>
            </div>
            <!-- /content -->

        </fieldset>
    </xsl:template>

</xsl:stylesheet>