<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">
    <xsl:output method="html"/>
    <xsl:template match="ns1:getSystemLogResponse">
        <h2>Logging Management</h2>
        <fieldset id='tempFullDiv' style="border:none;">
            <xsl:variable name="logLevel">
                <xsl:value-of select="return/logLevel"/>
            </xsl:variable>
            <xsl:comment>
                <xsl:value-of select="$logLevel"/>
            </xsl:comment>
            <div>
                <br/>
                <label for="log_ps">Persist all Configuration Changes &#160;&#160;&#160;</label>
                <input tabindex="1">
                    <xsl:attribute name="id">persistLogId</xsl:attribute>
                    <xsl:attribute name="name">persistLogId</xsl:attribute>
                    <xsl:attribute name="type">checkbox</xsl:attribute>
                    <xsl:attribute name="style">margin-left: 0px;</xsl:attribute>
                    <xsl:attribute name="value">true</xsl:attribute>
                    <xsl:attribute name="checked">true</xsl:attribute>
                </input>
                <br/>
                <br/>
            </div>
            <div id="formset">
                <xsl:call-template name="globalLoggers"/>
                <xsl:call-template name="appenders"/>
                <xsl:call-template name="loggers"/>
            </div>
        </fieldset>
    </xsl:template>
    <xsl:template name="globalLoggers">
        <form>
            <fieldset>
                <xsl:variable name="logLevel">
                    <xsl:value-of select="return/logLevel"/>
                </xsl:variable>
                <legend>Global Log4J Configuration</legend>
                <div>
                    <label for="log">Log Level</label>
                    <select id="globalLogLevelSettingCombo" tabindex="1">
                        <option>
                            <xsl:attribute name="value">TRACE</xsl:attribute>
                            <xsl:if test="$logLevel='TRACE'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            TRACE
                        </option>
                        <option>
                            <xsl:attribute name="value">DEBUG</xsl:attribute>
                            <xsl:if test="$logLevel='DEBUG'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            DEBUG
                        </option>
                        <option>
                            <xsl:attribute name="value">INFO</xsl:attribute>
                            <xsl:if test="$logLevel='INFO'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            INFO
                        </option>
                        <option>
                            <xsl:attribute name="value">WARN</xsl:attribute>
                            <xsl:if test="$logLevel='WARN'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            WARN
                        </option>
                        <option>
                            <xsl:attribute name="value">ERROR</xsl:attribute>
                            <xsl:if test="$logLevel='ERROR'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            ERROR
                        </option>
                        <option>
                            <xsl:attribute name="value">FATAL</xsl:attribute>
                            <xsl:if test="$logLevel='FATAL'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            FATAL
                        </option>
                        <option>
                            <xsl:attribute name="value">OFF</xsl:attribute>
                            <xsl:if test="$logLevel='OFF'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            OFF
                        </option>
                    </select>
                </div>
                <div>
                    <label for="log_p">Log Pattern</label>
                    <input tabindex="2">
                        <xsl:attribute name="id">globalLogPatternField</xsl:attribute>
                        <xsl:attribute name="type">text</xsl:attribute>
                        <xsl:attribute name="size">50</xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:value-of select="return/logPattern"/>
                        </xsl:attribute>
                    </input>
                </div>
                <div class="buttonrow">
                    <input tabindex="4">
                        <xsl:attribute name="value">Update</xsl:attribute>
                        <xsl:attribute name="onclick">
                            javascript:setGlobalLogData();return false;
                        </xsl:attribute>
                        <xsl:attribute name="type">button</xsl:attribute>
                    </input>
                    &#160;
                    <input tabindex="4">
                        <xsl:attribute name="value">Restore Defaults</xsl:attribute>
                        <xsl:attribute name="onclick">
                            javascript:restoreDefaults();return false;
                        </xsl:attribute>
                        <xsl:attribute name="type">button</xsl:attribute>
                    </input>
                </div>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template name="appenders">
        <form>
            <fieldset>
                <xsl:variable name="selectedAppenderName">
                    <xsl:value-of select="return/selectedAppenderData/name"/>
                </xsl:variable>
                <xsl:variable name="selectedAppenderIsFileAppender">
                    <xsl:value-of select="return/selectedAppenderData/isFileAppender"/>
                </xsl:variable>
                <xsl:variable name="selectedAppenderIsSysLogAppender">
                    <xsl:value-of select="return/selectedAppenderData/isSysLogAppender"/>
                </xsl:variable>
                <xsl:variable name="selectedAppenderThreshold">
                    <xsl:value-of select="return/selectedAppenderData/threshold"/>
                </xsl:variable>
                <xsl:variable name="selectedAppenderFacility">
                    <xsl:value-of select="return/selectedAppenderData/facility"/>
                </xsl:variable>
                <legend>Configure Log4J Appenders</legend>
                <div>
                    <label for="log">Name</label>
                    <select id="appeanderNameSettingCombo" tabindex="5">
                        <xsl:attribute name="onchange">
                            javascript:updateAppenderData();return false;
                        </xsl:attribute>
                        <xsl:for-each select="return/appenderData">
                            <option>
                                <xsl:attribute name="value">
                                    <xsl:value-of select="name"/>
                                </xsl:attribute>
                                <xsl:if test="$selectedAppenderName = name">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                <xsl:value-of select="name"/>
                            </option>
                        </xsl:for-each>

                    </select>
                </div>
                <div>
                    <label for="log_p">Log Pattern</label>
                    <input tabindex="6">
                        <xsl:attribute name="id">appenderLogPatternField</xsl:attribute>
                        <xsl:attribute name="type">text</xsl:attribute>
                        <xsl:attribute name="size">50</xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:value-of select="return/selectedAppenderData/pattern"/>
                        </xsl:attribute>
                    </input>

                </div>
                <div>
                    <label for="log_t">Threshold</label>
                    <select id="appenderThresholdCombo" tabindex="7">
                        <option>
                            <xsl:attribute name="value">TRACE</xsl:attribute>
                            <xsl:if test="$selectedAppenderThreshold='TRACE'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            TRACE
                        </option>
                        <option>
                            <xsl:attribute name="value">DEBUG</xsl:attribute>
                            <xsl:if test="$selectedAppenderThreshold='DEBUG'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            DEBUG
                        </option>
                        <option>
                            <xsl:attribute name="value">INFO</xsl:attribute>
                            <xsl:if test="$selectedAppenderThreshold='INFO'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            INFO
                        </option>
                        <option>
                            <xsl:attribute name="value">WARN</xsl:attribute>
                            <xsl:if test="$selectedAppenderThreshold='WARN'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            WARN
                        </option>
                        <option>
                            <xsl:attribute name="value">ERROR</xsl:attribute>
                            <xsl:if test="$selectedAppenderThreshold='ERROR'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            ERROR
                        </option>
                        <option>
                            <xsl:attribute name="value">FATAL</xsl:attribute>
                            <xsl:if test="$selectedAppenderThreshold='FATAL'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            FATAL
                        </option>
                        <option>
                            <xsl:attribute name="value">OFF</xsl:attribute>
                            <xsl:if test="$selectedAppenderThreshold='OFF'">
                                <xsl:attribute name="selected">true</xsl:attribute>
                            </xsl:if>
                            OFF
                        </option>
                    </select>
                </div>
                <div id="appenderLogFileDiv">
                    <xsl:if test="$selectedAppenderIsFileAppender = 'false'">
                        <xsl:attribute name="style">display:none</xsl:attribute>
                    </xsl:if>
                    <label for="log_f">Log File</label>
                    <input tabindex="8">
                        <xsl:attribute name="id">appenderLogFile</xsl:attribute>
                        <xsl:attribute name="type">text</xsl:attribute>
                        <xsl:attribute name="size">50</xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:value-of select="return/selectedAppenderData/logFile"/>
                        </xsl:attribute>
                    </input>
                </div>
                <div id="appenderSysLogDiv">
                    <xsl:if test="$selectedAppenderIsSysLogAppender = 'false'">
                        <xsl:attribute name="style">display:none</xsl:attribute>
                    </xsl:if>
                    <div>
                        <label for="log_f">Sys Log Host</label>
                        <input tabindex="9">
                            <xsl:attribute name="id">appenderSysLogHost</xsl:attribute>
                            <xsl:attribute name="type">text</xsl:attribute>
                            <xsl:attribute name="size">50</xsl:attribute>
                            <xsl:attribute name="value">
                                <xsl:value-of select="return/selectedAppenderData/sysLogHost"/>
                            </xsl:attribute>
                        </input>
                    </div>
                    <div>
                        <label for="log_f">Facility</label>
                        <select id="appenderFacilitySettingCombo" tabindex="10">
                            <option>
                                <xsl:attribute name="value">kern</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='kern'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_KERN
                            </option>
                            <option>
                                <xsl:attribute name="value">user</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='user'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_USER
                            </option>
                            <option>
                                <xsl:attribute name="value">mail</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='mail'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_MAIL
                            </option>
                            <option>
                                <xsl:attribute name="value">daemon</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='daemon'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_DAEMON
                            </option>
                            <option>
                                <xsl:attribute name="value">auth</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='auth'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_AUTH
                            </option>
                            <option>
                                <xsl:attribute name="value">syslog</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='syslog'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_SYSLOG
                            </option>
                            <option>
                                <xsl:attribute name="value">lpr</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='lpr'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LPR
                            </option>
                            <option>
                                <xsl:attribute name="value">news</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='news'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_NEWS
                            </option>
                            <option>
                                <xsl:attribute name="value">uucp</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='uucp'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_UUCP
                            </option>
                            <option>
                                <xsl:attribute name="value">cron</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='cron'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_CRON
                            </option>
                            <option>
                                <xsl:attribute name="value">authpriv</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='authpriv'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_AUTHPRIV
                            </option>
                            <option>
                                <xsl:attribute name="value">ftp</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='ftp'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_FTP
                            </option>
                            <option>
                                <xsl:attribute name="value">local0</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local0'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL0
                            </option>
                            <option>
                                <xsl:attribute name="value">local1</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local1'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL1
                            </option>
                            <option>
                                <xsl:attribute name="value">local2</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local2'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL2
                            </option>
                            <option>
                                <xsl:attribute name="value">local3</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local3'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL3
                            </option>
                            <option>
                                <xsl:attribute name="value">local4</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local4'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL4
                            </option>
                            <option>
                                <xsl:attribute name="value">local5</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local5'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL5
                            </option>
                            <option>
                                <xsl:attribute name="value">local6</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local6'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL6
                            </option>
                            <option>
                                <xsl:attribute name="value">local7</xsl:attribute>
                                <xsl:if test="$selectedAppenderFacility='local7'">
                                    <xsl:attribute name="selected">true</xsl:attribute>
                                </xsl:if>
                                LOG_LOCAL7
                            </option>
                        </select>
                    </div>
                </div>
                <div class="buttonrow">
                    <input tabindex="11">
                        <xsl:attribute name="value">Update</xsl:attribute>
                        <xsl:attribute name="type">button</xsl:attribute>
                        <xsl:attribute name="onclick">javascript:storeAppenderData();return false;
                        </xsl:attribute>
                    </input>
                </div>
            </fieldset>
        </form>
    </xsl:template>
    <xsl:template name="loggers">
        <form>
            <fieldset>
                <legend>Configure Log4J Loggers</legend>

                <!-- TODO: Filter loggers -->
                <!-- TODO fill the table with log info-->
                <label for="log_ps">Filter Loggers by &#160;&#160;&#160;</label>
                <input>
                    <xsl:attribute name="id">filterLogId</xsl:attribute>
                    <xsl:attribute name="name">filterLogId</xsl:attribute>
                    <xsl:attribute name="type">text</xsl:attribute>
                    <xsl:attribute name="style">margin-left: 0px;</xsl:attribute>
                    <xsl:attribute name="value"></xsl:attribute>
                    <xsl:attribute name="size">46</xsl:attribute>
                </input>
                <input>
                    <xsl:attribute name="id">beginsWithId</xsl:attribute>
                    <xsl:attribute name="name">beginsWithId</xsl:attribute>
                    <xsl:attribute name="type">submit</xsl:attribute>
                    <xsl:attribute name="style">margin-left: 0px;</xsl:attribute>
                    <xsl:attribute name="value">Starts With</xsl:attribute>
                    <xsl:attribute name="onClick">javascript:showLoggers(document.getElementById('filterLogId').value,'true');return false;</xsl:attribute>
                </input>
                <input>
                    <xsl:attribute name="id">containsId</xsl:attribute>
                    <xsl:attribute name="name">containsId</xsl:attribute>
                    <xsl:attribute name="type">submit</xsl:attribute>
                    <xsl:attribute name="style">margin-left: 0px;</xsl:attribute>
                    <xsl:attribute name="value">Contains</xsl:attribute>
                    <xsl:attribute name="onClick">javascript:showLoggers(document.getElementById('filterLogId').value,'false'); return false;</xsl:attribute>
                </input>
                <br/><br/>
                <div id="divLogConfig.loggers" style="height:600px;position:relative;scrolling:auto;">
                    <strong>Loading Loggers ...</strong>
                </div>
            </fieldset>
        </form>
    </xsl:template>
</xsl:stylesheet>