<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="ns1:getTransportDetailsResponse" xmlns:ns1="http://org.apache.axis2/xsd">
    	<div id="formset">
            <xsl:choose>
                <xsl:when test="return">
                    <div>
                        <table class="styled">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Value</th>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:for-each select="return">
                                       <tr>
                                           <xsl:if test="position() mod 2 = 1">
                                               <xsl:attribute name="bgcolor">#EEEFFB</xsl:attribute>
                                           </xsl:if>
                                            <td>Active</td>
                                            <td><xsl:value-of select="active"/></td>
                                        </tr>
                                        <xsl:for-each select="parameters">
                                            <tr>
                                                <xsl:if test="position() mod 2 = 0">
                                                   <xsl:attribute name="bgcolor">#EEEFFB</xsl:attribute>
                                               </xsl:if>
                                                <td>
                                                    <xsl:value-of select="name"/>
                                                </td>
                                                <td>
                                                    <xsl:value-of select="value"/>
                                                </td>
                                            </tr>

                                        </xsl:for-each>

                                </xsl:for-each>
                            </tbody>
                        </table>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <b>
                        <i>Transport Information is not available</i>
                    </b>
                </xsl:otherwise>

            </xsl:choose>
		</div>
    </xsl:template>
</xsl:stylesheet>