<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:param name="conditionalJavaversion">1.5</xsl:param>
    <xsl:param name="javaVersion">1.5</xsl:param>

    <xsl:template match="initializeService" >
        <table>
        	<tr>
        		<td><h2>Service &amp; Service Group Management</h2></td>
				<td valign="top">&#160;&#160;&#160;&#160;
					<a id="rss_link">
						<xsl:attribute name="href">#</xsl:attribute>
						<xsl:attribute name="onClick">javascript:openWindowHTTP('rss');return false;</xsl:attribute>
						<xsl:attribute name="target">_blank</xsl:attribute>
						<xsl:attribute name="title">WSO2 WSAS RSS 2.0</xsl:attribute>
						<xsl:attribute name="alt">WSO2 WSAS RSS 2.0</xsl:attribute>
						<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
					</a>&#160;&#160;&#160;&#160;
					<a id="atom_link">
						<xsl:attribute name="href">#</xsl:attribute>
                        <xsl:attribute name="onClick">javascript:openWindowHTTP('atom');return false;</xsl:attribute>
                        <xsl:attribute name="target">_blank</xsl:attribute>
						<xsl:attribute name="title">WSO2 WSAS Atom 1.0</xsl:attribute>
						<xsl:attribute name="alt">WSO2 WSAS Atom 1.0</xsl:attribute>
						<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
					</a>
				</td>
			</tr>
        </table>
        
        <fieldset style="border:none;">
            <div id="formsetWrapper">
                <div id="formset">
                    <xsl:call-template name="addNewServicesTemplate"/>
                </div>
                <div id="faultyServices" style="display:none;"></div>
            </div>
            <p>&#160;</p>
            <div id="listServicesInformation">
                <p>Refreshing service list...</p>
            </div>
        </fieldset>
    </xsl:template>


    <xsl:template name="addNewServicesTemplate">
    	<div id="formset">
            <form>
                <fieldset>
                    <legend>Add New Service</legend>
                    <div>
                        <table style="border:none;">
                            <tbody>
                                <tr>
                                    <td>
                                        <a alt="Upload Service Artifact (.aar, .dbs)" >
                                            <xsl:attribute name="title">Upload Service Artifact (.aar, .dbs)</xsl:attribute>
                                            <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="id">axis2_link1</xsl:attribute>
                                            <xsl:attribute name="onclick">javascript:showPOJOArchieveUploadScreen('add_create_axis2_aar.xsl');return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Upload Service Artifact (.aar, .dbs)</xsl:text>
                                        </a>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <td>
                                        <a alt="Upload Jar Artifact (.jar,.zip)" >
                                            <xsl:attribute name="title">Upload Jar Artifact (.jar, .zip)</xsl:attribute>
                                            <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="id">axis2_link1</xsl:attribute>
                                            <xsl:attribute name="onclick">javascript:showJarZipFileUploadScreen('add_new_jar_zip.xsl');return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Upload Jar Artifact (.jar, .zip)</xsl:text>
                                        </a>
                                    </td>
                                </tr>
                                <xsl:choose>
                                    <xsl:when test="$conditionalJavaversion='1.4'">
                                        <tr>
                                            <td>
                                                <a alt="Upload POJO Artifact - JSR-181 Annotated/JAX-WS (.jar, .class)" >
                                                    <xsl:attribute name="title">Upload POJO Artifact - JSR-181 Annotated/JAX-WS (.jar, .class)</xsl:attribute>
                                                    <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                                    <xsl:attribute name="href">#</xsl:attribute>
                                                    <xsl:attribute name="id">axis2_link2</xsl:attribute>
                                                    <xsl:attribute name="onclick">javascript:wso2.wsf.Util.alertWarning("This feature is only suported on JDK 1.5 &amp; higher. You are currently using JDK " + "<xsl:value-of select="$javaVersion"/> ");return false;</xsl:attribute>
                                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;Upload POJO Artifact - JSR-181 Annotated/JAX-WS (.jar, .class)</xsl:text>
                                                </a>
                                            </td>
                                        </tr>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <tr>
                                            <td>
                                                <a alt="Upload POJO Artifact - JSR-181 Annotated/JAX-WS (.jar, .class)" >
                                                    <xsl:attribute name="title">Upload POJO Artifact - JSR-181 Annotated/JAX-WS (.jar, .class)</xsl:attribute>
                                                    <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                                    <xsl:attribute name="href">#</xsl:attribute>
                                                    <xsl:attribute name="id">axis2_link</xsl:attribute>
                                                    <xsl:attribute name="onclick">javascript:showPOJOArchieveUploadScreen('add_pojo_service.xsl');return false;</xsl:attribute>
                                                    <xsl:text>&#160;&#160;&#160;&#160;&#160;Upload POJO Artifact - JSR-181 Annotated/JAX-WS (.jar, .class)</xsl:text>
                                                </a>
                                            </td>
                                        </tr>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <tr>
                                    <td>
                                        <a alt="Upload Spring Service" >
                                            <xsl:attribute name="title">Upload Spring Service</xsl:attribute>
                                            <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="id">spring_link</xsl:attribute>
                                            <xsl:attribute name="onclick">javascript:showSpringArchieveUploadScreen();return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Upload Spring Service</xsl:text>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <a alt="Upload Axis1 Service" >
                                            <xsl:attribute name="title">Axis1 Service deployed on Axis2</xsl:attribute>
                                            <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="id">axis1_link</xsl:attribute>
                                            <xsl:attribute name="onclick">javascript:showAxis1WSDDUploadScreen();return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Upload Axis1 Service (.wsdd)</xsl:text>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <a alt="Define Data Service" >
                                            <xsl:attribute name="title">Define Data Service</xsl:attribute>
                                            <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="id">data_service_link</xsl:attribute>
                                            <xsl:attribute name="onclick">javascript:addNewDataService();return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Define Data Service</xsl:text>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <a alt="Define EJB Service" >
                                            <xsl:attribute name="title">Define EJB Service</xsl:attribute>
                                            <xsl:attribute name="style">white-space:nowrap;</xsl:attribute>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="id">ejb_link</xsl:attribute>
                                            <xsl:attribute name="onclick">javascript:ejbProviderConfig();return false;</xsl:attribute>
                                            <xsl:text>&#160;&#160;&#160;&#160;&#160;Define EJB Service</xsl:text>
                                        </a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </fieldset>
            </form>
        </div>
    </xsl:template>
</xsl:stylesheet>
