<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="html"/>

    <xsl:template match="ns:listServiceGroupResponse/return | ns:configureMTOMResponse/return" xmlns:ns="http://org.apache.axis2/xsd">
        <xsl:variable name="serviceGroupName" select="group_name"/>
        <xsl:variable name="enableMTOM" select="enableMTOM" />
        <fieldset style='border: 0px;'>
            <div>
                <h4><a href='#' onClick='javascript:showServiceInitializer(); return false;'>Services</a>&#160;&gt;&#160;[<xsl:value-of select="$serviceGroupName" />]&#160;Service Group</h4>
                <h2>Service Group Management&#160;[<xsl:value-of select="$serviceGroupName" />]</h2>
            </div>
            <div>
                <table class="styledLeft">
                    <thead>
                        <tr>
                            <th colspan="2">General</th>
                        </tr>
                    </thead>
                    <tr>
                        <td>
                            <strong>Service Group Name</strong>
                        </td>
                        <td>
                            <xsl:value-of select="$serviceGroupName"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>MTOM</strong>
                        </td>
                        <td>
                            <select>
                                <xsl:attribute name="id">serviceGroupLevelMOTOMHandlingId</xsl:attribute>
                                <xsl:attribute name="onchange">javascript:configureMTOM(this[this.selectedIndex].value,'<xsl:value-of select="$serviceGroupName"/>');return false;</xsl:attribute>
                                <option>
                                    <xsl:attribute name="value">true</xsl:attribute>
                                    <xsl:if test="$enableMTOM='true'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    True
                                </option>
                                <option>
                                    <xsl:attribute name="value">false</xsl:attribute>
                                    <xsl:if test="$enableMTOM='false'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    False
                                </option>
                                <option>
                                    <xsl:attribute name="value">optional</xsl:attribute>
                                    <xsl:if test="$enableMTOM='optional'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    Optional
                                </option>
                            </select>
                        </td>
                        &#160;&#160;&#160;&#160;
                    </tr>
                </table>
            </div>

            <div>
                <a id='operations_link' href='#' onclick='javascript:getServiceGroupSpecificParametersForConfig("{$serviceGroupName}");return false;'>&#160;&#160;&#160;&#160;&#160;&#160;Manage Service Group Parameters</a>
            </div>
            <div>
                <a id='module_view_link' href='#' onclick='javascript:engageModulePerServiceGroup("{$serviceGroupName}");return false;'>&#160;&#160;&#160;&#160;&#160;&#160;Manage Module Engagements</a>
            </div>
            <div>
                <a id='create_svc_link' href='#' onclick='javascript:dumpAAR("{$serviceGroupName}");return false;'>&#160;&#160;&#160;&#160;&#160;&#160;Create Service Archive</a>
            </div>
        </fieldset>
    </xsl:template>

</xsl:stylesheet>