<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
        <!--  Link header to be populated by java script -->
        <div id="listPolicyInfoEditHeader"></div>
        <fieldset style="border:none;">
        <xsl:choose>
            <xsl:when test="return">

                <div id="formset">
                 <form>
                  <fieldset>
                           <legend>Service Policies</legend>

                           <xsl:for-each select="return">
                               <xsl:variable name="textBoxId"><xsl:value-of select="position()"/>_service_policy_text_</xsl:variable>
                               <div>
                                    <td><xsl:value-of select="wrapper"/></td>
                               </div>
                               <div>
                                    <td>
                                        <textarea cols="80" rows="10">
                                          <xsl:attribute name="id"><xsl:value-of select="$textBoxId"/></xsl:attribute>
                                          <xsl:apply-templates select="polycies"/>  
                                        </textarea>
                                    </td>
                               </div>
                               <div class='buttonraw'>
                                     <!-- update button -->
                                     <td>
                                        <input>
                                            <xsl:attribute name="type">button</xsl:attribute>
                                            <xsl:attribute name="value">Update</xsl:attribute>
                                            <xsl:attribute name="onClick">javascript:setServiceSpecificPolicyFromConfig(lastUsedServiceId,lastUsedServiceVersion,document.getElementById('<xsl:value-of select="$textBoxId"/>').value);return false;</xsl:attribute>
                                            <xsl:attribute name="tabindex">
                                                 <xsl:value-of select="position()"/>
                                            </xsl:attribute>
                                        </input>
                                    </td>
                               </div>

                     </xsl:for-each>
                 </fieldset>

          </form>
        </div>
      </xsl:when>
            <xsl:otherwise>
                <div id="formset">
                    <form>
                        <fieldset>
                            <legend>Service Policies</legend>
                                 <p>No service policies found.</p>
                        </fieldset>
                    </form>
                </div>
            </xsl:otherwise>
      </xsl:choose>
    </fieldset>
    </xsl:template>
    <xsl:template match="polycies">
        <xsl:value-of select="."/>
    </xsl:template>
</xsl:stylesheet>


