<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
        <fieldset style="border:none;">
        <!--  Link header to be populated by java script -->
        <div id="listServiceParamEditHeader" />
        <!-- custom header for message display -->
        <div id="serviceConfigUpdate" />

        <xsl:choose>
            <xsl:when test="return">
				<div id="formset">
					<form>
						<fieldset>
							<legend>Edit service specific parameters</legend>
                            <table class="emptyTable">
                                <xsl:for-each select="return">
                                    <xsl:if test="parameter/@name!=''">
                                        <tr style="clear:both;">
                                            <td>
                                                <label style="width:25%;">&#160;<xsl:value-of select="parameter/@name"/></label>
                                            </td>
                                            <td>
                                                <input type="text">
                                                    <xsl:attribute name="size">50</xsl:attribute>
                                                    <xsl:attribute name="value"><xsl:value-of select="normalize-space(parameter)"/></xsl:attribute>
                                                    <xsl:attribute name="id"><xsl:value-of select="generate-id()"/></xsl:attribute>
                                                    <xsl:attribute name="tabindex">
                                                       <xsl:value-of select="position()"/>
                                                    </xsl:attribute>
                                                    <xsl:if test="@locked='true'">
                                                        <xsl:attribute name="disabled">true</xsl:attribute>
                                                    </xsl:if>
                                                </input>
                                            </td>
                                            <td>
                                                <nobr>
                                                    &#160;&#160;
                                                    <a href="#" >
                                                        <xsl:attribute name="class">remove_param</xsl:attribute>
                                                        <xsl:attribute name="id"><xsl:value-of select="parameter/@name"/></xsl:attribute>
                                                        <xsl:attribute name="onClick">javascript:removeServiceSpecificParameter(this);return false;</xsl:attribute>
                                                        <xsl:attribute name="title">Remove Service Parameter</xsl:attribute>
                                                        <xsl:attribute name="alt">Remove</xsl:attribute>
                                                        &#160;&#160;&#160;&#160;
                                                    </a>
                                                </nobr>
                                            </td>
                                        </tr>
                                    </xsl:if>
                                </xsl:for-each>
                            </table>
                            <div class="buttonrow">
								<!-- update button -->
								<input type="button" value="update">
									<xsl:attribute name="onClick">javascript:
										var arrayOfNames=new Array();
										var arrayOfValues=new Array();
										<xsl:for-each select="return">
											arrayOfNames[<xsl:value-of select="position()-1"/>] = '<xsl:value-of select="parameter/@name"/>';
											arrayOfValues[<xsl:value-of select="position()-1"/>] = (document.getElementById('<xsl:value-of select="generate-id()"/>').value);
										</xsl:for-each>
										processServiceOperationParameterConfigUpdate(arrayOfNames,arrayOfValues);
										return false;
									</xsl:attribute>
								</input>
								<!-- add button -->
								<input type="button" value="add">
									<xsl:attribute name="onClick">javascript:addServiceSpecificParameters();return false;</xsl:attribute>
								</input>
							</div>
						</fieldset>
					</form>
				</div>
            </xsl:when>
            <xsl:otherwise>
				<table>
					 <tr>
						 <td>No parameters found.</td>
					 </tr>
					<tr>
						<td>
							<!-- add button -->
							<input type="button" value="add">
								<xsl:attribute name="onClick">javascript:addServiceSpecificParameters();return false;</xsl:attribute>
							</input>
						</td>
					</tr>
				</table>
            </xsl:otherwise>
        </xsl:choose>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>


