<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
        <!--  Link header to be populated by java script -->
		<div id="listServiceGroupParamHeader"></div>
        
		<!-- end of link header block -->

        <xsl:choose>
            <xsl:when test="return">

        <table class="styled">
            <thead>
                 <tr>
                     <th>Parameter Name</th>
                     <th>Parameter Value</th>
                 </tr>
            </thead>
            <tbody>
            <xsl:for-each select="return">
				<tr><td><strong><xsl:value-of select="parameter/@name"/></strong></td>
					<td><xsl:value-of select="parameter"/></td>
				</tr>
             </xsl:for-each>
            </tbody>
         </table>
            </xsl:when>
            <xsl:otherwise>
                <!--  Link header to be populated by java script -->
		
                <p>No Service Group specific parameters present.</p>

            </xsl:otherwise>
        </xsl:choose>
        <iframe src="_blank.html" onload="javascript:showlistServiceGroupParamHeader(document.getElementById('listServiceGroupParamHeader'));"
                        scrolling="no" style="visibility:hidden"
                        width="0" height="0"/>
    </xsl:template>
</xsl:stylesheet>


