<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:key name="kkk" match="controlOperation"  use="."/>

    <xsl:template match="ns1:listAllOperationsResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <!--  Link header to be populated by java script -->
        <xsl:variable name="controlOperationsCount" select="count(key('kkk','true'))" />
        <div id="listOperationsHeader"></div>

        <h2>Published Operations</h2>
        <table class="styled" id="published_operations_table">
			<thead>
				<tr>
					<th>Name</th>
					<th>Actions</th>
                    <th>MTOM</th>
                </tr>
			</thead>
			<tbody>
            <xsl:for-each select="return">
                <xsl:variable name="isControlOperation">
                    <xsl:value-of select="controlOperation"/>
                </xsl:variable>
                <xsl:variable name="enableMTOM" select="enableMTOM" />
                <xsl:for-each select="name">
                    <xsl:if test="$isControlOperation='false'">
                        <tr>
                            <td>
                                <a>
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="onClick">
                                        javascript:getOperationSpecficParameters('<xsl:value-of select="."/>'); return false;
                                    </xsl:attribute>
                                    <xsl:value-of select="."/>
                                </a>
                            </td>
                            <td>
                                <xsl:text>&#160;&#160;&#160;</xsl:text>
                                <a id="edit_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="title">Edit operation specific parameters</xsl:attribute>
                                    <xsl:attribute name="onClick">
                                        javascript:getOperationSpecficParametersForConfig('<xsl:value-of select="."/>'); return false;
                                    </xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
                                </a>
                                <xsl:text>&#160;&#160;</xsl:text>
                                <a id="module_view_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="title">View engaged modules</xsl:attribute>
                                    <xsl:attribute name="onClick">
                                        javascript:engageModulePerOperation('<xsl:value-of select="."/>'); return false;
                                    </xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
                                </a>
                                <xsl:text>&#160;&#160;</xsl:text>
                                <a id="handler_view_link">
                                    <xsl:attribute name="href">#</xsl:attribute>
                                    <xsl:attribute name="title">View Axis2 handler</xsl:attribute>
                                    <xsl:attribute name="onClick">
                                        javascript:listEngagedOperationHandlers('<xsl:value-of select="."/>'); return false;
                                    </xsl:attribute>
                                    <xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
                                </a>
                                <!--<xsl:text>&#160;&#160;</xsl:text>-->
                            </td>
                            <td>
                                <select>
                                    <xsl:attribute name="id">serviceLevelMOTOMHandlingId</xsl:attribute>
                                    <xsl:attribute name="onchange">javascript:configOperationMTOM(this[this.selectedIndex].value,'<xsl:value-of select="."/>');return false;</xsl:attribute>
                                    <option>
                                        <xsl:attribute name="value">true</xsl:attribute>
                                        <xsl:if test="$enableMTOM='true'">
                                            <xsl:attribute name="selected">true</xsl:attribute>
                                        </xsl:if>
                                        True
                                    </option>
                                    <option>
                                        <xsl:attribute name="value">false</xsl:attribute>
                                        <xsl:if test="$enableMTOM='false'">
                                            <xsl:attribute name="selected">true</xsl:attribute>
                                        </xsl:if>
                                        False
                                    </option>
                                    <option>
                                        <xsl:attribute name="value">optional</xsl:attribute>
                                        <xsl:if test="$enableMTOM='optional'">
                                            <xsl:attribute name="selected">true</xsl:attribute>
                                        </xsl:if>
                                        Optional
                                    </option>
                                </select>
                                &#160;&#160;&#160;&#160;&#160;&#160;
                            </td>
                        </tr>
                    </xsl:if>

                </xsl:for-each>
			</xsl:for-each>
			</tbody>
		</table>
		 <xsl:if test="$controlOperationsCount > 0">
            <p>&#160;&#160;</p>
            <h2>Control Operations</h2>
            <table class="styled">
                <thead>
                    <tr>
                        <th>Name</th>
                    </tr>
                </thead>
                <xsl:for-each select="return">
                    <xsl:variable name="isControlOperation">
                        <xsl:value-of select="controlOperation"/>
                    </xsl:variable>
                    <xsl:for-each select="name">
                        <xsl:if test="$isControlOperation='true'">
                            <tr>
                                <td>
                                    <xsl:value-of select="."/>
                                </td>
                            </tr>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:for-each>
            </table>

        </xsl:if>

    </xsl:template>
</xsl:stylesheet>