<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">
    <xsl:output method="html"/>

    <xsl:template match="ns1:getAllKeyStoreNamesResponse">
        <h2>Transport Management Wizard</h2>
        <fieldset style="border:none;">
            <div id='formset'>
                <form>
                    <fieldset>
                    <legend>Step 3: Select Keystore</legend>
                    <xsl:choose>
                        <xsl:when test="return">
                            <xsl:for-each select="return">
                                <span class="radioButtonRow">
                                    <input>
                                        <xsl:attribute name="type">radio</xsl:attribute>
                                        <xsl:attribute name="name">keystoreName</xsl:attribute>
                                        <xsl:attribute name="id">keystoreName</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
                                        <xsl:attribute name="tabindex">
                                        	<xsl:value-of select="position()"/>
                                        </xsl:attribute>
                                        <xsl:if test="position()=1">
                                            <xsl:attribute name="checked"/>
                                        </xsl:if>
                                    </input>
                                    &#160;&#160;<xsl:value-of select="."/>
                                    <br/>
                                </span>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <strong>Error occurred while listing Keystores</strong>
                        </xsl:otherwise>
                    </xsl:choose>

                <div class='buttonrow'>
                    <input type='button'>
                        <xsl:attribute name="value">&lt;&#160;Back</xsl:attribute>
                        <xsl:attribute name="onclick">javascript:addNewTransport_2();return false;</xsl:attribute>
                    </input>
                    <input type='button'>
                        <xsl:attribute name="value">Next&#160;&gt;</xsl:attribute>
                        <xsl:attribute name="onclick">javascript:createHTTPSTransport(document.getElementsByName('keystoreName'));return false;</xsl:attribute>
                    </input>
                </div>
            </fieldset>
            </form>
            </div>
        </fieldset>
    </xsl:template>

    <xsl:template match="ns1:getPrivateKeysResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <h2>Keystore Management</h2>
                <fieldset style="border:none;">
                    <div id='formset'>
                        <form>
                            <fieldset>
                                <legend>Step 2: Select private key</legend>
                                <xsl:choose>
                                    <xsl:when test="return">
                                        <xsl:for-each select="return">
                                            <span class="radioButtonRow">
                                                <input>
                                                    <xsl:attribute name="type">radio</xsl:attribute>
                                                    <xsl:attribute name="name">privateKeyKS</xsl:attribute>
                                                    <xsl:attribute name="id">privateKeyKS</xsl:attribute>
                                                    <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
                                                    <xsl:if test = "position()=1">
                                                        <xsl:attribute name="checked"/>
                                                    </xsl:if>
                                                </input>
                                                &#160;&#160;<xsl:value-of select="."/>
                                                <br/>
                                            </span>
                                        </xsl:for-each>

                                        <div class='buttonrow'>
                                            <input type='button'>
                                                <xsl:attribute name="value">&lt;&#160;Back</xsl:attribute>
                                                <xsl:attribute name="onclick">javascript:keystoreSetting();return false;</xsl:attribute>
                                            </input>
                                            <input type='button'>
                                                <xsl:attribute name="value">Next&#160;&gt;</xsl:attribute>
                                                <xsl:attribute name="onclick">javascript:selectedSpecificPrivatekey(document.getElementsByName('privateKeyKS'));return false;</xsl:attribute>
                                            </input>
                                        </div>
                                    </xsl:when>


                                    <xsl:otherwise>
                                        <strong>No private keys found in the keystore which was uploaded</strong>
                                        <div class='buttonrow'>
                                            <input type='button'>
                                                <xsl:attribute name="value">&lt;&#160;Back</xsl:attribute>
                                                <xsl:attribute name="onclick">javascript:keystoreSetting();return false;</xsl:attribute>
                                            </input>
                                        </div>
                                    </xsl:otherwise>
                                </xsl:choose>

                    </fieldset>
            </form>
            </div>
        </fieldset>
    </xsl:template>

 </xsl:stylesheet>

