<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <!-- Value of resourceHTTPEPR will be injected via javascript -->
    <xsl:param name="resourceHTTPEPR"/>

    <xsl:template match="ns1:listServiceGroupsResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <fieldset style="border:none;">
            <h2>List Services</h2>
        <xsl:choose>
            <xsl:when test="return">
                <table class="styled" id="service_groups_info_table">
                    <thead>
                        <tr>
                            <th>Service Groups</th>
                            <th>Services</th>
                            <th>View</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:for-each select="return">
                            <xsl:variable name="topCount" select="position()"/>
                            <tr>
                                <xsl:if test="$topCount mod 2 = 1">
                                    <xsl:attribute name="bgcolor">#EEEFFB</xsl:attribute>
                                </xsl:if>
                                <td>
                                    <xsl:attribute name="rowspan">
                                        <xsl:value-of select="count(services) + 1"/>
                                    </xsl:attribute>
                                    <xsl:value-of select="group_name"/>
                                </td>
                                <td/>
                            </tr>
                            <xsl:for-each select="services">
                                <xsl:sort/>
                                <tr>
                                    <xsl:if test="$topCount mod 2 = 1">
                                        <xsl:attribute name="bgcolor">#EEEFFB</xsl:attribute>
                                    </xsl:if>
                                    <td>
                                        <a>
                                            <xsl:variable name="serviceTypes" select="../serviceTypes"/>
                                            <xsl:attribute name="class"><xsl:value-of select="substring-after($serviceTypes,'#')"/>_exlink</xsl:attribute>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="onClick">javascript:listGeneralServiceData('<xsl:value-of select="."/>'); return false;</xsl:attribute>
                                            <xsl:value-of select="."/>
                                        </a>
                                    </td>
                                    <td style="width: 200px;">
                                        <a>
                                            <xsl:attribute name="href"><xsl:value-of select="$resourceHTTPEPR"/><xsl:value-of select="."/>?wsdl&amp;annotation=true</xsl:attribute>
                                            <xsl:attribute name="target">_blank</xsl:attribute>
                                            <xsl:text>WSDL&#160;1.1</xsl:text>
                                        </a>
                                        <xsl:text>&#160;&#160;</xsl:text>
                                        <a>
                                            <xsl:attribute name="href"><xsl:value-of select="$resourceHTTPEPR"/><xsl:value-of select="."/>?wsdl2&amp;annotation=true</xsl:attribute>
                                            <xsl:attribute name="target">_blank</xsl:attribute>
                                            <xsl:text>WSDL&#160;2.0</xsl:text>
                                        </a>
                                        <xsl:text>&#160;&#160;&#160;</xsl:text>
                                        <a>
                                            <xsl:attribute name="href"><xsl:value-of select="$resourceHTTPEPR"/><xsl:value-of select="."/>?xsd&amp;annotation=true</xsl:attribute>
                                            <xsl:attribute name="target">_blank</xsl:attribute>
                                            <xsl:text>Schema</xsl:text>
                                        </a>
                                        <xsl:text>&#160;&#160;&#160;</xsl:text>
                                        <a>
                                            <xsl:attribute name="href"><xsl:value-of select="$resourceHTTPEPR"/><xsl:value-of select="."/>?policy</xsl:attribute>
                                            <xsl:attribute name="target">_blank</xsl:attribute>
                                            <xsl:text>Policy</xsl:text>
                                        </a>
                                        <xsl:text>&#160;&#160;&#160;</xsl:text>
                                        <a>
                                            <xsl:attribute name="href">#</xsl:attribute>
                                            <xsl:attribute name="onClick">javascript:openWindowHTTP('<xsl:value-of select="."/>?cert');return false;</xsl:attribute>
                                            <xsl:attribute name="target">_blank</xsl:attribute>
                                            <xsl:text>Certificate</xsl:text>
                                        </a>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </xsl:for-each>
                    </tbody>
                </table>
			</xsl:when>
            <xsl:otherwise>
                <b>
                    <i>No Active Services</i>
                </b>
            </xsl:otherwise>
        </xsl:choose>
        </fieldset>
    </xsl:template>

    <xsl:template match="serviceTypes">
		<xsl:param name="serviceNameParam"/>
	    <xsl:for-each select=".">
            <xsl:variable name="serviceType" select="."/>
            <xsl:variable name="seperator">#</xsl:variable>
            <xsl:variable name="serviceName" select="substring-before($serviceType,$seperator)" />
		    <xsl:if test="$serviceNameParam = $serviceName">
	    	       <xsl:value-of select="substring-after($serviceType,$seperator)"/>
	    	</xsl:if>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>