<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="ns1:listServiceModulesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Service Level</legend>
				        <table class="styled">
				        	<thead>
				        		<tr>
				        			<th style="width: 200px">Engaged Modules</th>
				                    <th>Actions</th>
				                </tr>
				        	</thead>
				            <xsl:for-each select="return">
								<tr><td>
									<xsl:value-of select="moduleId"/>-<xsl:value-of select="moduleVersion"/>
								</td>
				                <td>
									<nobr> 
									<a href="#" id="cancel_link">
				                      <xsl:attribute name="onClick">javascript:disengageModuelfromServiceExec('<xsl:value-of select="moduleId"/>','<xsl:value-of select="moduleVersion"/>'); return false;</xsl:attribute>
				                      <xsl:attribute name="title">Disengage <xsl:value-of select="."/> module</xsl:attribute>
				                      <xsl:attribute name="alt">Disengage</xsl:attribute>
				                      &#160;&#160;&#160;&#160;&#160;&#160;
				                    </a>
				                    </nobr>
				                </td></tr>
				            </xsl:for-each>
				        </table>
                    </fieldset>
                </form>
        </xsl:when>
            <xsl:otherwise>
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Service Level</legend>
                        <div>
                            <b>
                                <i>No engaged modules found</i>
                            </b>
                        </div>
                    </fieldset>
                </form>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- For Modules Engaged on Services Parent -->

    <xsl:template match="ns1:listServicesParentEngagedModulesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
            <xsl:choose>
                <xsl:when test="return">
                    <form>
                        <fieldset>
                            <legend>Modules Engaged at Service Group Level</legend>
				            <table class="styled">
				                <thead>
				                    <tr>
				                        <th style="width: 200px">Engaged Modules</th>
				                    </tr>
				                </thead>
				                <xsl:for-each select="return">
				                    <tr>
				                        <td>
				                            <xsl:value-of select="moduleId"/>-<xsl:value-of select="moduleVersion"/>
				                        </td>
				                    </tr>
				                </xsl:for-each>
				            </table>
                        </fieldset>
                    </form>
            </xsl:when>
                <xsl:otherwise>
                    <form>
                        <fieldset>
                            <legend>Modules Engaged at Service Group Level</legend>
                            <div>
                                <b>
                                    <i>No engaged modules found</i>
                                </b>
                            </div>
                        </fieldset>
                    </form>
                </xsl:otherwise>
            </xsl:choose>
    </xsl:template>

    <!-- For Listing Operations parent parent -->
    <xsl:template match="ns1:listOperationsParentParentEngagedModulesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
            <xsl:choose>
                <xsl:when test="return">
                    <form>
                        <fieldset>
                            <legend>Modules Engaged at Service Group Level</legend>
				            <table class="styled">
				                <thead>
				                    <tr>
				                        <th style="width: 200px">Engaged Modules</th>
				                    </tr>
				                </thead>
				                <xsl:for-each select="return">
				                    <tr>
				                        <td>
				                            <xsl:value-of select="moduleId"/>-<xsl:value-of select="moduleVersion"/>
				                        </td>
				                    </tr>
				                </xsl:for-each>
				            </table>
                        </fieldset>
                    </form>
            </xsl:when>
                <xsl:otherwise>
                    <form>
                        <fieldset>
                            <legend>Modules Engaged at Service Group Level</legend>
                            <div>
                                <b>
                                    <i>No engaged modules found</i>
                                </b>
                            </div>
                        </fieldset>
                    </form>
                </xsl:otherwise>
            </xsl:choose>
	</xsl:template>

    <!-- For Globally engaged modules -->

    <xsl:template match="ns1:listGloballyEngagesModulesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <form>
                    <fieldset>
                        <legend>Globally Engaged Modules</legend>
				        <table class="styled">
				        	<thead>
				        		<tr>
				        			<th style="width: 200px">Engaged Modules</th>
				                </tr>
				        	</thead>
				            <xsl:for-each select="return">
								<tr>
				                    <td>
				                        <xsl:value-of select="moduleId"/>-<xsl:value-of select="moduleVersion"/>
				                    </td>
				                </tr>
				            </xsl:for-each>
				        </table>
                    </fieldset>
                </form>
        </xsl:when>
            <xsl:otherwise>
                <form>
                    <fieldset>
                        <legend>Globally Engaged Modules</legend>
                        <div>
                            <b>
                                <i>No engaged modules found</i>
                            </b>
                        </div>
                    </fieldset>
                </form>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ns1:listServiceGroupModulesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Service Group Level</legend>
				        <table class="styled">
				        	<thead>
				        		<tr>
				        			<th style="width: 200px">Engaged Modules</th>
				                    <th>Actions</th>
				                </tr>
				        	</thead>
				            <xsl:for-each select="return">
								<tr><td>
                                    <xsl:value-of select="moduleId"/>-<xsl:value-of select="moduleVersion"/>
								</td>
				                <td>
									<nobr> <a href="#" id="cancel_link">
				                                <xsl:attribute name="onClick">javascript:disengageModuelfromServiceGroupExec('<xsl:value-of select="moduleId"/>', '<xsl:value-of select="moduleVersion"/>'); return false;</xsl:attribute>
				                                <xsl:attribute name="title">Disengage <xsl:value-of select="."/> module</xsl:attribute>
				                                <xsl:attribute name="alt">Disengage</xsl:attribute>
				                                &#160;&#160;&#160;&#160;&#160;&#160;
				                            </a>
				                    </nobr>
				                </td></tr>
				            </xsl:for-each>
				        </table>
                    </fieldset>
                </form>
        </xsl:when>
            <xsl:otherwise>
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Service Group Level</legend>
                        <div>
                            <b>
                                <i>No engaged modules found</i>
                            </b>
                        </div>
                    </fieldset>
                </form>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>