<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="req:listOperationModulesResponse"
                  xmlns:req="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Operation Level</legend>
                        <table class="styled">
                            <thead>
                                <tr>
                                    <th style="width: 200px">Engaged Modules</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:for-each select="return">
                                    <tr>
                                        <td>
                                            <xsl:value-of select="moduleId"/>-<xsl:value-of select="moduleVersion"/>
                                        </td>
                                        <td>
                                            <nobr>
                                                <a href="#" id="cancel_link">
                                                    <xsl:attribute
                                                            name="onClick">
                                                        javascript:disengageModuelfromOperationExec('<xsl:value-of select="moduleId"/>', '<xsl:value-of select="moduleVersion"/>'); return false;
                                                    </xsl:attribute>
                                                    <xsl:attribute name="title">Disengage <xsl:value-of select="."/> module</xsl:attribute>
                                                    <xsl:attribute name="alt">Disengage</xsl:attribute>
                                                    &#160;&#160;&#160;&#160;&#160;&#160;
                                                </a>
                                            </nobr>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                        </table>
                    </fieldset>
                </form>
            </xsl:when>
            <xsl:otherwise>
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Operation Level</legend>
                        <div>
                            <b>
                                <i>No engaged modules found</i>
                            </b>
                        </div>
                    </fieldset>
                </form>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!--Read only PerService Modules -->
    <xsl:template match="ns1:listServiceModulesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Service Level</legend>
        <table class="styled">
        	<thead>
        		<tr>
        			<th style="width: 200px">Engaged Modules</th>                    
                </tr>
        	</thead>
            <xsl:for-each select="return">
                <tr>
                    <td>
                        <xsl:value-of select="moduleId"/>-<xsl:value-of select="moduleVersion"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
                    </fieldset>
                </form>
        </xsl:when>
            <xsl:otherwise>
                <form>
                    <fieldset>
                        <legend>Modules Engaged at Service Level</legend>
                        <div>
                            <b>
                                <i>No engaged modules found</i>
                            </b>
                        </div>
                    </fieldset>
                </form>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>