<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd">
    <xsl:output method="html"/>

    <xsl:template match="ns1:getKeyStoresResponse">
    	<div id="formset">
    		<fieldset style="border: none">
                <xsl:choose>
                        <xsl:when test="return">
                            <table class="styled">
                                <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <xsl:for-each select="return">
                                    <tr>
                                        <td>
                                            <xsl:attribute name="title"><xsl:value-of select="keyStoreFilename"/></xsl:attribute>
                                            <a>
                                                <xsl:attribute name="href">#</xsl:attribute>
                                                <xsl:attribute name="onClick">javascript:getKeystoreInfo('<xsl:value-of select="keyStoreName"/>'); return false;</xsl:attribute>
                                                <xsl:value-of select="keyStoreName"/>
                                            </a>

                                        </td>
                                        <td>
                                            <xsl:value-of select="keyStoreType"/>
                                        </td>
                                        <td>
                                            <nobr>
                                                <a id="import_link">
                                                    <xsl:attribute name="href">#</xsl:attribute>
                                                    <xsl:attribute name="title">Import Certificate</xsl:attribute>
                                                    <xsl:attribute name="onClick">javascript:showImportCertificate('<xsl:value-of select="keyStoreName"/>'); return false;</xsl:attribute>
                                                    <xsl:attribute name="alt">Import</xsl:attribute>
                                                    <xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
                                                </a>
                                                <xsl:text>&#160;&#160;</xsl:text>
                                                <a href="#" id="cancel_link">
                                                    <xsl:attribute name="onClick">javascript:deleteKeyStore('<xsl:value-of select="keyStoreName"/>'); return false;</xsl:attribute>
                                                    <xsl:attribute name="title">Remove Keystore <xsl:value-of select="keyStoreName"/> </xsl:attribute>
                                                    <xsl:attribute name="alt">Remove</xsl:attribute>
                                                    &#160;&#160;&#160;&#160;
                                                </a>
                                            </nobr>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                            </table>
                    </xsl:when>
                </xsl:choose>
			</fieldset>
		</div>
    </xsl:template>

    <xsl:template match="ns1:getKeystoreInfoResponse">
        <xsl:variable name="keyStoreName" select="return/keyStoreName"/>
        <xsl:variable name="type" select="return/type"/>
        <div>
            <h4><a href="#" onclick="javascript:keystoreSetting(); return false;">Keystore Management</a>&#160;&gt;&#160;Keystore Viewer&#160;<i>[Name:<xsl:value-of select="$keyStoreName"/>&#160;Type:<xsl:value-of select="$type"/>]</i></h4>
        </div>
        <fieldset style="border: none">
            <div id="formset">
                <form>
                    <fieldset>
                        <legend>Certificates</legend>
                        <xsl:choose>
                            <xsl:when test="return/certs">
                                <xsl:call-template name="drawCertTable">
                                    <xsl:with-param name="parent" select="return/certs"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <strong>There are no certificates available</strong>
                            </xsl:otherwise>
                        </xsl:choose>
                    </fieldset>
                </form>
                <form>
                    <fieldset>
                        <legend>Private Key</legend>
                        <xsl:call-template name="drawCertTable">
                            <xsl:with-param name="parent" select="return/key"/>
                        </xsl:call-template>
                    </fieldset>
                </form>
                <form>
                    <fieldset>
                        <legend>Private Key Value</legend>
                        <textarea>
                            <xsl:attribute name="cols">77</xsl:attribute>
                            <xsl:attribute name="rows">15</xsl:attribute>
                            <xsl:attribute name="readonly"/>
                            <xsl:value-of select="return/keyValue"/>
                        </textarea>

                    </fieldset>
                </form>
            </div>
        </fieldset>
    </xsl:template>

    <xsl:template name="drawCertTable">
        <xsl:param name="parent"/>
        <table class="styled">
            <thead>
                <tr>
                    <th>Alias</th>
                    <th>IssuerDN</th>
                    <th>NotAfter</th>
                    <th>NotBefore</th>
                    <th>SerialNumber</th>
                    <th>SubjectDN</th>
                    <th>Version</th>
                </tr>
            </thead>

            <tbody>
                <xsl:for-each select="$parent">
                    <tr>
                        <td>
                            <xsl:value-of select="alias"/>
                        </td>
                        <td>
                            <xsl:value-of select="issuerDN"/>
                        </td>
                        <td>
                            <xsl:value-of select="notAfter"/>
                        </td>
                        <td>
                            <xsl:value-of select="notBefore"/>
                        </td>
                        <td>
                            <xsl:value-of select="serialNumber"/>
                        </td>
                        <td>
                            <xsl:value-of select="subjectDN"/>
                        </td>
                        <td>
                            <xsl:value-of select="version"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>
 </xsl:stylesheet>
