<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
        <h4><a href="#" onClick="javascript:showServiceInitializer(); return false;">Services</a>&#160;&gt;&#160;EJB Provider Configuration > Step 1: Application server details</h4>
		
    	<fieldset style="border:none;">
        <div id="formset">
		<form name="existingEJBConfigurationsForm">
			<fieldset>
				<legend>Existing Configurations</legend>
        		<table class="styled">
        			<xsl:choose>
            			<xsl:when test="return">
							<thead>
								<tr>
									<th>Service Name</th>
					    			<th>Provider URL</th>
	    		        			<!--th>JNDI Context Class</th-->
	            					<th>Bean JNDI Name</th>
	            					<th>Actions</th>
	        					</tr>
							</thead>
	            			<xsl:for-each select="return">
	                		<tr>
								<td>
	                        		<xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        		<xsl:value-of select="serviceName"/>
	                    		</td>
			    				<td>
	                        		<xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        		<xsl:value-of select="providerURL"/>
	                    		</td>
	                    		<!--td>
	                        		<xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        		<xsl:value-of select="jndiContextClass"/>
	                    		</td-->
	                    		<td>
	                        		<xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        		<xsl:value-of select="beanJNDIName"/>
	                    		</td>
	                    		<td>
	                        		<xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        		&#160;&#160;
	                        		<a id="edit_link">
										<xsl:attribute name="href">#</xsl:attribute>
										<xsl:attribute name="onClick">javascript:getServiceSpecficParametersForConfig('<xsl:value-of select="serviceName"/>','ejb_service'); return false;</xsl:attribute>
										<xsl:attribute name="title">Edit EJB Configuration</xsl:attribute>
										&#160;&#160;&#160;&#160;
									</a>
									<!--
	                        		&#160;&#160;&#160;&#160;
	                        		<a id="cancel_link">
										<xsl:attribute name="href">#</xsl:attribute>
										<xsl:attribute name="onClick">javascript:deleteEJBConfiguration('<xsl:value-of select="beanJNDIName"/>','<xsl:value-of select="providerURL"/>'); return false;</xsl:attribute>
										<xsl:attribute name="title">Delete EJB Configuration</xsl:attribute>
										&#160;&#160;&#160;&#160;
									</a>
	                        		&#160;&#160;
									-->
	                    		</td>
	                		</tr>
	            			</xsl:for-each>
	            		</xsl:when>
        	    	<xsl:otherwise>
					<tr>
						<td style="border: none;">
							<label style="width: 200px; color: brown; align: left;">No existing EJB Configurations</label>
						</td>
					</tr>
        	    	</xsl:otherwise>
        		</xsl:choose>
	        </table>
		</fieldset>
	</form>
	<p>&#160;</p>
	<form name="addEJBApplicationServerForm">
		<fieldset>
			<legend>Application Server Details</legend>
			    <table>
			        <tbody>
					    <tr><td colspan="2" /></tr>
							<tr>
								<td colspan="2">
									<input type="radio" id="appServerConfiguration1" name="appServerConfiguration1" value="existingEJBServer"  onclick="javascript:toggleEJBAppServerConfigurationEditScreen(this.value);" />
									<b>Use existing</b>
								</td>
							</tr>
							<tr>
                                <td colspan="2">
                                    <div>
                                           <table>
                                               <tr>
                                                   <td>
                                                       <label>Server Configuration</label>
                                                   </td>
                                                   <td>
                                                       <select id="existingAppServerConfigurations" name="existingAppServerConfigurations" >
                                                        <xsl:attribute name="onchange">javascript:setDefaultServerValues(this,document);return false;</xsl:attribute>
                                                    </select>
                                                   </td>
                                               </tr>
                                           </table>
                                    </div>
								</td>
							</tr>
							<tr>
                                <td colspan="2">
                                    <input type="radio" name="appServerConfiguration2" id="appServerConfiguration2" value="addNewEJBServer"
									onclick="javascript:toggleEJBAppServerConfigurationEditScreen(this.value);" checked="true"/>
									<b>Add New</b>
                                </td>
                            </tr>
                        <tr>
                            <td colspan="2">
                                <table>
                                    <tr>
                                        <td>
                                                <label>Server Type<font color='red'>*</font></label>
                                            </td>
                                            <td>
                                                <select id="serverType" name="serverType">
                                                    <xsl:attribute name="onchange">javascript:setDefaultServerValues(this,document);return false;</xsl:attribute>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="providerUrl">Provider URL<font color='red'>*</font></label>
                                            </td>
                                            <td>
                                                <input type="text" id="providerUrl" tabindex="2" size="40" maxlength="100"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="jndiContextClass">JNDI Context Class<font color='red'>*</font></label>
                                            </td>
                                            <td>
                                                <input 	type="text" id="jndiContextClass" tabindex="3" size="40" maxlength="100"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="userName">User Name</label>
                                            </td>
                                            <td>
                                                <input type="text" id="userName" tabindex="4" size="15" maxlength="20"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="password">Password</label>
                                            </td>
                                            <td>
                                                <input type="password" id="password" tabindex="5" size="15" maxlength="20"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="password">Confirm Password</label>
                                            </td>
                                            <td>
                                                <input type="password" id="confirmPassword" tabindex="5" size="15" maxlength="20"/>
                                            </td>
                                        </tr>
                                    </table>
                                    <div>

                                    </div>

                                    <div>
                                        <label/>
                                        <input type="button" id="addApplicationServerButton" name="addApplicationServerButton" onclick="javascript:addApplicationServer();" value=" Add Application Server " />
                                    </div>
                                </td>
                            </tr>
                    </tbody>
                </table>
        </fieldset>
                        <br/>
                        <div class="buttonrowBottom">							
			    			<input id="ejbStep0NextButton" type="button"  onclick="javascript:addApplicationServerElement();" value=" Next > "></input>
							<input type="button" onClick="javascript:startServices(this,1); return false;" value="Cancel"/>
	   	                </div>
				</form>
			<p>&#160;</p>
        </div>
	    <iframe src="_blank.html" onload="javascript:loadAppServersComboBox();"
			scrolling="no" style="visibility:hidden"
			width="0" height="0"/>

	    <iframe src="_blank.html" onload="javascript:loadExistingAppServerConfigComboBox();"
			scrolling="no" style="visibility:hidden"
			width="0" height="0"/>
			
	    <!-- <iframe src="_blank.html" onload="javascript:ejbProviderStep1DisableFields();"
			scrolling="no" style="visibility:hidden"
			width="0" height="0"/> -->
		
        </fieldset>
    </xsl:template>
</xsl:stylesheet>