<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="html" indent="yes"/>

    <!--single point of entry or main -->
    <xsl:template match="/">
        <xsl:apply-templates select="dataWrapper"/>
    </xsl:template>

    <xsl:template match="dataWrapper">
        <xsl:variable name="dsStep" select="@ds_step"/>
        <fieldset style="border:none;">
            <table>
                <tr>
                    <td style="vertical-align: top; padding: 0;">
                        <div id="formDiv">
                            <div id="formset">
                                <xsl:apply-templates select="data"/>
                            </div>

                            <div id="formset_button">
                                <div>
                                    <xsl:choose>
                                        <xsl:when test="$dsStep=0">
                                            <input type="button" value="OK">
                                                <xsl:attribute name="onclick">javascript:configStepOne();return false;</xsl:attribute>
                                            </input>
                                        </xsl:when>
                                    </xsl:choose>
                                    <input type="button" onClick="closeContainer(); return false;" value="Cancel"/>

                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
        </fieldset>
    </xsl:template>

    <xsl:template match="data">
        <xsl:variable name="dsStep" select="../@ds_step"/>
        <xsl:choose>
            <xsl:when test="$dsStep=0">
                 <xsl:call-template name="ds_config"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>


    <!-- This is the template that will initiate the Data service configuration iff a new Data Service
         is going to create. Current context will be data. Parent is return.
    -->
    <xsl:template name="ds_config">
        <xsl:variable name="dataSourceType" select="../@dataSourceType"/>
        <form>
            <fieldset style="width: 520px;">
                <legend>Configuration</legend>
                <table>

                <xsl:if test="$dataSourceType='RDBMS'">
                    <tr>
                        <td>
                            <label>Database Type<font color='red'>*</font></label>
                        </td>
                        <td>
                            <xsl:variable name="jdbcURL" select="config/property[@name='org.wso2.ws.dataservice.protocol']"/>
                            <select>
                                <xsl:attribute name="id">databaseServerType</xsl:attribute>
                                <xsl:attribute name="name">databaseServerType</xsl:attribute>
                                <xsl:attribute name="onchange">javascript:setJDBCValues(this,document);return false;</xsl:attribute>
                                <option>
                                    <xsl:attribute name="value">#</xsl:attribute>
                                    --SELECT--
                                </option>
                                <xsl:for-each select="../dbServerData">
                                    <option>
                                        <xsl:attribute name="value"><xsl:value-of select="jdbcUrl"/>#<xsl:value-of select="driverClass"/></xsl:attribute>
                                        <xsl:if test="contains($jdbcURL,protocol)">
                                            <xsl:attribute name="selected">true</xsl:attribute>
                                        </xsl:if>
                                        <xsl:value-of select="serverId"/>
                                    </option>
                                </xsl:for-each>
                            </select>
                        </td>
                    </tr>
                </xsl:if>


                <xsl:for-each select="config/property">
                    <tr>
                        <td>
                        <label>
                            <xsl:choose>
                                <!-- RDBMS main properties -->
                                <xsl:when test="@name = 'org.wso2.ws.dataservice.driver'">Driver Class</xsl:when>
                                <xsl:when test="@name = 'org.wso2.ws.dataservice.protocol'">JDBC URL</xsl:when>
                                <xsl:when test="@name = 'org.wso2.ws.dataservice.user'">User name</xsl:when>
                                <xsl:when test="@name = 'org.wso2.ws.dataservice.password'">Password</xsl:when>
                                <xsl:when test="@name = 'org.wso2.ws.dataservice.minpoolsize'">Min. Pool size</xsl:when>
                                <xsl:when test="@name = 'org.wso2.ws.dataservice.maxpoolsize'">Max. Pool size</xsl:when>                                
                                <!-- EXCEL main properties -->
                                <xsl:when test="@name = 'excel_datasource'">Excel File Location<font color='red'>*</font></xsl:when>
                                <!-- CSV main properties -->
                                <xsl:when test="@name = 'csv_datasource'">CSV File Location<font color='red'>*</font></xsl:when>
                                <xsl:when test="@name = 'csv_hasheader'">Header available<font color='red'>*</font></xsl:when>
                                <xsl:when test="@name = 'csv_columnseperator'">Column separator</xsl:when>
                                <xsl:when test="@name = 'csv_columns'"><!--  This is a hidden field --></xsl:when>
                                <xsl:when test="@name = 'csv_columnordinal'"><!-- This is a hidden field  --></xsl:when>
                                <xsl:when test="@name = 'csv_startingrow'">Starting Row</xsl:when>
                                <xsl:when test="@name = 'csv_maxrowcount'">Max. no of rows to read</xsl:when>
                                <!-- JNDIResource main properties -->
                                <xsl:when test="@name = 'jndi_context_class'">JNDI Context Class<font color='red'>*</font></xsl:when>
                                <xsl:when test="@name = 'jndi_provider_url'">Provider URL<font color='red'>*</font></xsl:when>
                                <xsl:when test="@name = 'jndi_resource_name'">Resource Name<font color='red'>*</font></xsl:when>
                                <xsl:when test="@name = 'jndi_username'">User name</xsl:when>
                                <xsl:when test="@name = 'jndi_password'">Password</xsl:when>

                                <!-- work-a-round for other properties added by user -->
                                <xsl:otherwise>
                                    <xsl:value-of select="@name"/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!--<font color='red'>*</font>-->
                        </label>
                        </td>
                        <td>
                            <!-- distinguish between text,password fields/select boxes/file upload dialogs -->
	                    	<xsl:choose>
	                    		<xsl:when test="@name = 'org.wso2.ws.dataservice.password'">
	                    			<input>
	                    				<xsl:attribute name="type">text</xsl:attribute>
	                    				<xsl:attribute name="size">30</xsl:attribute>
	                    				<xsl:attribute name="value"><xsl:value-of select="text()" /></xsl:attribute>
	                    				<xsl:attribute name="id"><xsl:value-of select="@name" /></xsl:attribute>
	                    			</input>
	                    		</xsl:when>
	                    		<xsl:when test="contains(@name,'_hasheader')">
	                    			<xsl:variable name="hasHeader">
	                    			   <xsl:value-of select="text()" />
	                    			</xsl:variable>
			  	                    <select>
	                					<xsl:attribute name="id"><xsl:value-of select="@name" /></xsl:attribute>
	                					<xsl:attribute name="onchange">javascript:getCSVHeaderColumnNames(document);return false;</xsl:attribute>
                                        <option>
                	                        <xsl:attribute name="value"></xsl:attribute>
                	                        --SELECT--
                                        </option>
                        				<option>
                            				<xsl:attribute name="value">true</xsl:attribute>
                            				<xsl:if test="$hasHeader='true'">
                                				<xsl:attribute name="selected">true</xsl:attribute>
                            				</xsl:if>
                            				TRUE
                        				</option>
                        				<option>
                            				<xsl:attribute name="value">false</xsl:attribute>
                            				<xsl:if test="$hasHeader='false'">
                                				<xsl:attribute name="selected">true</xsl:attribute>
                            				</xsl:if>
                            				FALSE
                        				</option>
                    				</select>
	                    		</xsl:when>
	                    		<xsl:when
	                    			test="contains(@name,'csv_datasource') or contains(@name,'excel_datasource')">
	                    			<input>
	                    			    <xsl:attribute name="type">text</xsl:attribute>
	                    			    <xsl:attribute name="id"><xsl:value-of select="@name" /></xsl:attribute>
	                    			    <xsl:attribute name="name"><xsl:value-of select="@name" /></xsl:attribute>
	                    			    <xsl:attribute name="size">30</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="text()" /></xsl:attribute>
	                    			</input>
	                    		</xsl:when>
	                    		<xsl:when
	                    			test="@name = 'csv_columns' or @name = 'csv_columnordinal'">
	                    			<input>
	                    			    <xsl:attribute name="type">hidden</xsl:attribute>
	                    			    <xsl:attribute name="id"><xsl:value-of select="@name" /></xsl:attribute>
	                    				<xsl:attribute name="value"><xsl:value-of select="text()" /></xsl:attribute>
	                    			</input>
	                    		</xsl:when>
	                    		<xsl:otherwise>
	                    			<input>
	                    			    <xsl:attribute name="type">text</xsl:attribute>
	                    				<xsl:attribute name="size">30</xsl:attribute>
	                    				<xsl:attribute name="value"><xsl:value-of select="text()" /></xsl:attribute>
	                    				<xsl:attribute name="id"><xsl:value-of select="@name" /></xsl:attribute>
	                    			</input>
	                    		</xsl:otherwise>
	                    	</xsl:choose>



                            <!--
                              remove parameter icon should not appear for RDBMS main parameter types,
                              all excel & csv parameters.
                             -->
	                    	<xsl:if test="not(contains(@name,'org.wso2.ws.dataservice.')
	                    	                     or contains(@name,'excel_')
	                    	                     or contains(@name,'csv_')
	                    	                     or contains(@name,'jndi_'))">
                            &#160;&#160;&#160;
                            <a alt="Remove">
                                <xsl:attribute name="title">Remove parameter<xsl:value-of select="@id"/>
                                </xsl:attribute>
                                <xsl:attribute name="onclick">javascript:remove_ds_param('<xsl:value-of select="@name"/>');return false;</xsl:attribute>
                                <xsl:attribute name="id">cancel_link</xsl:attribute>
                                <xsl:attribute name="href">#</xsl:attribute>
                                <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                            </a>
                        </xsl:if>
                        </td>
                    </tr>
                </xsl:for-each>
                </table>

                <div id="divCSVColumnSelection" style="display:none;">
                   <label>Column selection<font color='red'>*</font></label>
	               <select>
	                  <xsl:attribute name="onclick">javascript:setCSVColumnSelection();return false;</xsl:attribute>
	                  <xsl:attribute name="id">csvColumnSelection</xsl:attribute>
	                  <xsl:attribute name="multiple">true</xsl:attribute>
	               </select>
                </div>
                <input type="hidden"/>

                <xsl:if test="$dataSourceType='RDBMS'">
                    <input type="button" value="Test Connection">
                        <xsl:attribute name="onClick">javascript:testJDBCConnection(document.getElementById('org.wso2.ws.dataservice.driver').value, document.getElementById('org.wso2.ws.dataservice.protocol').value, document.getElementById('org.wso2.ws.dataservice.user').value, document.getElementById('org.wso2.ws.dataservice.password').value);return false;</xsl:attribute>
                    </input>
                </xsl:if>
            </fieldset>
        </form>
    </xsl:template>
</xsl:stylesheet>
