<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="">

    <xsl:template match="*">
        <!--<h4><div id="dataServiceAddQueryHeader"></div></h4>-->
        <!--<h2>Data Service Management - Result Mapping</h2>-->
        <fieldset style="border:none;">
     	<div id="formset">
            <form name="dataServiceAddQueryOutputMappingForm">
               <fieldset>
					<legend>Result to Output Mapping</legend>
                    <div>
                    	<label width="30%">Grouping element name</label>
                       	<input type="text">
                       	<xsl:attribute name="size">50</xsl:attribute>
                       	<xsl:attribute name="id">txtDataServiceWrapElement</xsl:attribute>
                       	<xsl:attribute name="value"><xsl:value-of select="result/@element"/></xsl:attribute>
                       	<xsl:attribute name="onchange">javascript:queryWENOnChange(this.value);</xsl:attribute>
                       	</input>
                    </div>
                    <div>
                    	<label width="30%">Row name</label>
                       	<input type="text">
                       	<xsl:attribute name="size">50</xsl:attribute>
                       	<xsl:attribute name="id">txtDataServiceRowName</xsl:attribute>
                       	<xsl:attribute name="value"><xsl:value-of select="result/@rowName"/><xsl:value-of select="result/@rowname"/></xsl:attribute>
                       	<xsl:attribute name="onchange">javascript:queryRNOnChange(this.value);</xsl:attribute>
                       	</input>
                    </div>
					
					
					<table class="styled" width="50%">
						<thead>
							<tr>
								<th>Mapping type</th>
								<th>Output Field Name</th>
								<th>Column Name</th>
							</tr>
						</thead>
					<xsl:for-each select="result/*">
						<xsl:choose>
							<xsl:when test="@href != ''">
								<tr>
									<td>Query</td>
									<td colspan="2"><xsl:value-of select="@href"/><xsl:value-of select="@href"/> </td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<td>Element</td>
									<td><xsl:value-of select="@name"/><xsl:value-of select="@href"/> </td>
									<td><xsl:value-of select="@column"/></td>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
                	</xsl:for-each>
                	</table>
                	<div>
                			<label><a alt="Add New">
                				<xsl:attribute name="title">Add new Output Mapping</xsl:attribute>
                				<xsl:attribute name="href">#</xsl:attribute>
                				<xsl:attribute name="onclick">javascript:addNewOutputMapping();return false;</xsl:attribute>
                				<xsl:text>Add New</xsl:text>
                			</a></label>
                	</div>
					
					<table>
						<thead>
							<tr>
								<th>Select Type</th>
								<th></th>
								<th></th>
							</tr>
						</thead>
						<tr>
							<td>
		                    	<select>
	    		                   	<xsl:attribute name="id">cmbDataServiceOMType</xsl:attribute>
	            		           	<xsl:attribute name="onchange">javascript:dataserviceOMTypeSelected(this.value);</xsl:attribute>
	                    		   	<option>
		                       			<xsl:attribute name="value">OutputElement</xsl:attribute>
		                       				Output Element
	                        			</option>
	                       			<option>
		                       			<xsl:attribute name="value">Query</xsl:attribute>
		                       			Query
	                        		</option>
                				</select>
							</td>
							
							<div id="divOMQuery" style="display: none;">
								<td>
		                    	<select>
    	                		<xsl:attribute name="id">cmbDataServiceQueryId</xsl:attribute>
								<xsl:for-each select="data/query">
		    	                   	<option>
			    	                   	<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
			        	               	<xsl:value-of select="@id"/>
		                	        </option>
	                			</xsl:for-each>
	                			</select>
								</td>
								<td>
									<input type="button" value="Done">
	                					<xsl:attribute name="onclick">javascript:addDataServiceOMQueryDone();return false;</xsl:attribute>
	                				</input>								
								</td>
		                	</div>	
							
							
                    		<div id="divOMElement" style="display: inline;">
								<td>
					                 <input type="text">
					                 <xsl:attribute name="size">20</xsl:attribute>
					                 <xsl:attribute name="id">txtDataServiceOMElementName</xsl:attribute>
					                 </input>
								</td>
								<td>
					                 <input type="text">
					                 <xsl:attribute name="size">20</xsl:attribute>
					                 <xsl:attribute name="id">txtDataServiceOMColumnName</xsl:attribute>
					                 </input>
								</td>
								<td>
						             <input type="button" value="Done">
						             	<xsl:attribute name="onclick">javascript:addDataServiceOMElementDone();return false;</xsl:attribute>
						             </input>
								</td>
		                    </div>					
						</tr>
                	</table>

                   <div class="buttonrow">
				<input type="button" value="Save Query">
           			<xsl:attribute name="onclick">javascript:updateDSWithNewQuery();return false;</xsl:attribute>
           		</input>
       			<input type="button" value="Save Mapping">
       				<xsl:attribute name="onclick">javascript:updateDSWithNewQuery();return false;</xsl:attribute>
       			</input>
           	</div>
					
                  </fieldset>
              </form>			  
			</div>

        </fieldset>
    </xsl:template>
</xsl:stylesheet>