<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="html" indent="yes"/>

    <xsl:param name="queryId" />
    <xsl:param name="operationName" />
    <xsl:param name="editOperationName"/>

    <!--single point of entry or main -->
    <xsl:template match="/">
        <xsl:apply-templates select="dataWrapper"/>
    </xsl:template>

    <xsl:template match="dataWrapper">
        <xsl:variable name="query" select="data/query[@id=$queryId]"/>
        <xsl:variable name="queries" select="data/query"/>
        <xsl:variable name="operation" select="data/operation[@name=$operationName]"/>
        <xsl:variable name="callQuery" select="$operation/call-query"/>
        <xsl:variable name="tmpOperationName">
            <xsl:choose>
                <xsl:when test="$operationName">
                     <xsl:value-of select="$operationName"/>
                </xsl:when>
                <xsl:when test="$editOperationName">
                     <xsl:value-of select="$editOperationName"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <div id="formset">
            <xsl:choose>
                <xsl:when test="$queries">
                    <xsl:for-each select="$queries">
                        <xsl:if test="position()=1 and not($queryId) and not($operationName)">
                            <form name="dataServicesAddEditOperations">
                                <fieldset style="width: 500px;">
                                    <legend>Operation Parameter Mappings</legend>
                                    <xsl:choose>
                                        <xsl:when test="not(param)">
                                            <strong>Input parameters are not available</strong>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:for-each select="param">
                                               <xsl:variable name="paramType" select="@type"/>
                                               <xsl:if test="$paramType='' or $paramType='IN' or $paramType='INOUT'">
                                                <label>
                                                    <xsl:value-of select="@name"/>                                                    
                                                </label>
                                                <input type="text">
                                                    <xsl:attribute name="size">30</xsl:attribute>
                                                    <xsl:attribute name="id"><xsl:value-of select="generate-id()"/>_genId</xsl:attribute>
                                                    <xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
                                                </input>
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </fieldset>
                            </form>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
            </xsl:choose>

            <xsl:if test="$queryId and not($operationName)">
                <form name="dataServicesAddEditOperations">
                    <fieldset style="width: 500px;">
                        <legend>Operation Parameter Mappings</legend>
                        <xsl:choose>
                            <xsl:when test="not($query/param)">
                                <strong>Input parameters are not available</strong>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:for-each select="$query/param">
                                    <xsl:variable name="paramType" select="@type"/>
                                    <xsl:if test="$paramType='' or $paramType='IN' or $paramType='INOUT'">
                                    <label>
                                        <xsl:value-of select="@name"/>
                                    </label>
                                    <input type="text">
                                        <xsl:attribute name="size">30</xsl:attribute>
                                        <xsl:attribute name="id"><xsl:value-of select="generate-id()"/>_genId</xsl:attribute>
                                    </input>
                                    </xsl:if>
                                </xsl:for-each>
                            </xsl:otherwise>
                        </xsl:choose>
                    </fieldset>
                </form>
            </xsl:if>
            <xsl:if test="$operationName">
                <form name="dataServicesAddEditOperations">
                    <fieldset style="width: 500px;">
                        <legend>Operation Parameter Mappings</legend>
                        <xsl:choose>
                            <xsl:when test="not($callQuery/with-param)">
                                <strong>Input parameters are not available</strong>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:for-each select="$callQuery/with-param">
                                    <label>
                                        <xsl:value-of select="@query-param"/>
                                    </label>
                                    <input type="text">
                                        <xsl:attribute name="size">30</xsl:attribute>
                                        <xsl:attribute name="id"><xsl:value-of select="generate-id()"/>_genId</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
                                    </input>
                                </xsl:for-each>
                            </xsl:otherwise>
                        </xsl:choose>
                    </fieldset>
                </form>
            </xsl:if>

        </div>
        <div>
            <xsl:choose>
                <xsl:when test="$queries">
                    <input type="button" value="OK">
                        <xsl:attribute name="onclick">javascript:var holderObject = new Object();
                            <xsl:for-each select="$queries">
                                <xsl:if test="position()=1 and not($queryId) and not($operationName)">
                                    holderObject["queryNameForOperation1234UUURRX"] = '<xsl:value-of select="@id"/>';
                                    <xsl:choose>
                                        <xsl:when test="param">
                                            <xsl:for-each select="param">
                                             <xsl:variable name="paramType" select="@type"/>
                                             <xsl:if test="$paramType='' or $paramType='IN' or $paramType='INOUT'">
                                                 holderObject["<xsl:value-of select="@name"/>"] = document.getElementById('<xsl:value-of select="generate-id()"/>_genId').value;
                                             </xsl:if>
                                            </xsl:for-each>
                                            addNewOperationForDataServiceOK(holderObject,"TRUE",'<xsl:value-of select="$tmpOperationName"/>');
                                        </xsl:when>
                                        <xsl:otherwise>
                                            addNewOperationForDataServiceOK(holderObject,"FALSE",'<xsl:value-of select="$tmpOperationName"/>');
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:if>
                            </xsl:for-each>
                            <xsl:if test="$queryId and not($operationName)">
                                holderObject["queryNameForOperation1234UUURRX"] = '<xsl:value-of select="$query/@id"/>';
                                <xsl:choose>
                                    <xsl:when test="$query/param">
                                        <xsl:for-each select="$query/param">
                                             <xsl:variable name="paramType" select="@type"/>
                                             <xsl:if test="$paramType='' or $paramType='IN' or $paramType='INOUT'">
                                                holderObject["<xsl:value-of select="@name"/>"] = document.getElementById('<xsl:value-of select="generate-id()"/>_genId').value;
                                             </xsl:if>
                                        </xsl:for-each>
                                        addNewOperationForDataServiceOK(holderObject,"TRUE",'<xsl:value-of select="$tmpOperationName"/>');
                                    </xsl:when>
                                    <xsl:otherwise>
                                        addNewOperationForDataServiceOK(holderObject,"FALSE",'<xsl:value-of select="$tmpOperationName"/>');
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:if>
                            <xsl:if test="$operationName">
                                 holderObject["queryNameForOperation1234UUURRX"] = '<xsl:value-of select="$callQuery/@href"/>';
                                <xsl:choose>
                                    <xsl:when test="$callQuery/with-param">
                                        <xsl:for-each select="$callQuery/with-param">
                                             holderObject["<xsl:value-of select="@query-param"/>"] = document.getElementById('<xsl:value-of select="generate-id()"/>_genId').value;
                                        </xsl:for-each>
                                        addNewOperationForDataServiceOK(holderObject,"TRUE",'<xsl:value-of select="$tmpOperationName"/>');
                                    </xsl:when>
                                    <xsl:otherwise>
                                        addNewOperationForDataServiceOK(holderObject,"FALSE",'<xsl:value-of select="$tmpOperationName"/>');
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:if>
                        </xsl:attribute>
                    </input>
                    <input type="button" onclick="closeContainer('divDSAddEditOperations'); return false;" value="Cancel"/>
                </xsl:when>
                <xsl:otherwise>
                     <input type="button" onclick="closeContainer('divDSAddEditOperations'); return false;" value="Cancel"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>

    </xsl:template>
</xsl:stylesheet>