<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:param name="paramName"/>
    <xsl:param name="paramSqlType"/>
    <xsl:param name="queryId"/>
    <xsl:param name="paramInOutType"/>
    <xsl:param name="paramOrdinal"/>
    <xsl:param name="edit"/>

    <!--single point of entry or main -->
    <xsl:template match="/">
        <xsl:apply-templates select="dataWrapper"/>
    </xsl:template>

    <xsl:template match="dataWrapper">
        <xsl:choose>
            <xsl:when test="not($paramName)">
                <xsl:call-template name="addEditInputMapping">
                    <xsl:with-param name="name"/>
                    <xsl:with-param name="sqlType"/>
                    <xsl:with-param name="type"/>
                    <xsl:with-param name="ordinal"/>                    
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="addEditInputMapping">
                    <xsl:with-param name="name" select="$paramName"/>
                    <xsl:with-param name="sqlType" select="$paramSqlType"/>
                    <xsl:with-param name="type" select="$paramInOutType"/>
                    <xsl:with-param name="ordinal" select="$paramOrdinal"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <div>
            <input type="button" onclick="addNewSpecificInputParam('{$queryId}',document.getElementById('inputMappingNameId').value, document.getElementById('inputMappingSqlTypeId'),document.getElementById('inputMappingOrdinalId').value,document.getElementById('inputMappingInOutTypeId'),'{$paramName}'); return false;" value="OK"/>
            <input type="button" onclick="closeContainer('divADDEditInputMapping');return false;" value="Cancel"/>
        </div>
    </xsl:template>

    <xsl:template name="addEditInputMapping">
        <xsl:param name="name"/>
        <xsl:param name="sqlType"/>
        <xsl:param name="type"/>
        <xsl:param name="ordinal"/>
        <div id="formset">
            <form name="dataServiceAddQueryForm">
                <fieldset style="width: 520px;">
                    <legend>Add/Edit Input Mapping</legend>
                    <div>
                        <label>Name<font color='red'>*</font></label>
                        <input type="text">
                            <xsl:attribute name="size">30</xsl:attribute>
                            <xsl:attribute name="id">inputMappingNameId</xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="$name"/></xsl:attribute>
                            <xsl:if test="$edit">
                                <!--<xsl:attribute name="disabled">true</xsl:attribute>-->
                                <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                            </xsl:if>
                        </input>
                    </div>
                        <div>
                            <label>SQL Type<font color='red'>*</font></label>
                            <select>
                                <xsl:attribute name="id">inputMappingSqlTypeId</xsl:attribute>
                                <option>
                                    <xsl:if test="$sqlType='STRING'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">STRING</xsl:attribute>
                                    STRING
                                </option>
                                <option>
                                    <xsl:if test="$sqlType='INTEGER'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">INTEGER</xsl:attribute>
                                    INTEGER
                                </option>
                                <option>
                                    <xsl:if test="$sqlType='DOUBLE'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">DOUBLE</xsl:attribute>
                                    DOUBLE
                                </option>
                                <option>
                                    <xsl:if test="$sqlType='DATE'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">DATE</xsl:attribute>
                                    DATE[yyyy-mm-dd]
                                </option>
                                <option>
                                    <xsl:if test="$sqlType='TIME'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">TIME</xsl:attribute>
                                    TIME[hh:mm:ss]
                                </option>
                                <option>
                                    <xsl:if test="$sqlType='TIMESTAMP'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">TIMESTAMP</xsl:attribute>
                                    TIMESTAMP
                                </option>                                
                                <!--TODO: add any more sqltypes-->
                            </select>
                        </div>
                        <div>
                            <label>IN/OUT Type<font color='blue'>*</font></label>
                            <select>
                                <xsl:attribute name="id">inputMappingInOutTypeId</xsl:attribute>
                                <option>
                                    <xsl:if test="$type=''">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value"></xsl:attribute>
                                    
                                </option>
                                <option>
                                    <xsl:if test="$type='IN'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">IN</xsl:attribute>
                                    IN
                                </option>
                                <option>
                                    <xsl:if test="$type='OUT'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">OUT</xsl:attribute>
                                    OUT
                                </option>                                
                                <option>
                                    <xsl:if test="$type='INOUT'">
                                        <xsl:attribute name="selected">true</xsl:attribute>
                                    </xsl:if>
                                    <xsl:attribute name="value">INOUT</xsl:attribute>
                                    INOUT
                                </option>
                            </select>
                        </div>
                    <div>
                        <label>Ordinal<font color='blue'>*</font></label>
                        <input type="text">
                            <xsl:attribute name="size">5</xsl:attribute>
                            <xsl:attribute name="id">inputMappingOrdinalId</xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="$ordinal"/></xsl:attribute>
                            <xsl:if test="$edit">
                                <!--<xsl:attribute name="disabled">true</xsl:attribute>-->
                                <xsl:attribute name="style">background-color:#E4E8F5;</xsl:attribute>
                            </xsl:if>
                        </input>
                    </div>
                    <div>
                        <label><font color='blue'>*Required only for stored procedures.</font></label>
                    </div>
                        
                </fieldset>
            </form>
        </div>
    </xsl:template>


</xsl:stylesheet>