<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="">

    <xsl:param name="dsHeader" />

    <!--single point of entry or main -->
    <xsl:template match="/">
        <xsl:apply-templates select="dataWrapper"/>
    </xsl:template>

    <xsl:template match="dataWrapper">
        <xsl:variable name="dsStep" select="@ds_step"/>
        <div id="dataServiceWrapper">
        <h4><a href="#" onClick="javascript:showServiceInitializer(); return false;">Services</a>&#160;&gt;&#160;Data&#160;Service&#160;Step-<xsl:value-of select="$dsHeader"/></h4>
        <fieldset style="border:none;">

                        <div id="formset">
                            <div align="right" style="margin-right: 11em">
                                <a class="exlink" href="http://wso2.org/wiki/display/wsf/Data+Services+and+Resources" target="_blank" >Data Services Specification</a>
                            </div>
                            <xsl:apply-templates select="data"/>
                        </div>

                        <div id="formset_button">
                            <div style="align: right;">
                                <xsl:if test="$dsStep=0">
                                    <input type="button"
                                           onclick="javascript:stepOneToStepTwo(); return false;"
                                           value=" Next &gt; "/>
                                </xsl:if>
                                <xsl:if test="$dsStep=1">
                                    <input type="button"
                                           onClick="stepTwoToStepOne();return false;"
                                           value=" &lt; Back"/>
                                    <input type="button"
                                           onClick="stepTwoToSetpFinal();return false"
                                           value=" Next &gt;"/>
                                </xsl:if>

                                <xsl:if test="$dsStep=2">
                                    <input type="button"
                                           onClick="setpFinalToSetpTwo();return false;"
                                           value=" &lt; Back "/>
                                    <input type="button" value="Finish">
                                        <xsl:attribute name="onclick">javascript:deployDataService();return false;</xsl:attribute>
                                    </input>
                                </xsl:if>
                                <input type="button" value="Cancel">
                                    <xsl:attribute name="onclick">javascript:startServices(this,1); return false;</xsl:attribute>
                                </input>
                            </div>
                        </div>

                        <div id="formset">
                            <form id="previewDSConfTextArea" name="previewDSConfTextAreaForm">
                                <fieldset>
                                    <legend>Preview of the Data Service configuration</legend>
                                    <div id="dsPreviewDiv" style="overflow:hidden"/>
                                </fieldset>
                            </form>
                        </div>
                    

        </fieldset>
        </div>
    </xsl:template>

    <xsl:template match="data">
        <xsl:variable name="dsStep" select="../@ds_step"/>
        <xsl:choose>
            <xsl:when test="$dsStep=0">
                 <xsl:call-template name="ds_config"/>
            </xsl:when>
            <xsl:when test="$dsStep=1">
                 <xsl:call-template name="ds_query"/>
            </xsl:when>
            <xsl:when test="$dsStep=2">
                <xsl:call-template name="ds_operation"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>


    <!-- This is the template that will initiate the Data service configuration iff a new Data Service
         is going to create. The XSLT context will be "data"
    -->
    <xsl:template name="ds_config">
        <xsl:variable name="dataServiceName" select="@name"/>
        <xsl:variable name="disableName" select="../@disable_name"/>
        <xsl:variable name="dataSourceType" select="../@dataSourceType"/>
        <xsl:variable name="transformDST" select="config/property"/>
        <form>
            <fieldset>
                <legend>Configuration</legend>
                <div>
                    <label>Service Name
                        <font color='red'>*</font>
                    </label>
                    <input type="text">
                        <xsl:attribute name="size">30</xsl:attribute>
                        <xsl:attribute name="id">dataServiceName</xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:value-of select="$dataServiceName"/>
                        </xsl:attribute>
                        <xsl:if test="$disableName">
                            <xsl:attribute name="disabled"/>
                        </xsl:if>
                    </input>
                </div>

                <div>
                    <label>Data Source<font color='red'>*</font>
                    </label>
                    <select id="databaseSourceType">
					   <xsl:attribute name="onchange">javascript:setConfigurationScreen(this[this.selectedIndex].value);return false;</xsl:attribute>
                        <xsl:if test="$disableName">
                            <xsl:attribute name="disabled">true</xsl:attribute>
                        </xsl:if>
                       <option>
                           <xsl:attribute name="value" />
                           --SELECT--
                       </option>
					   <option>
                           <xsl:attribute name="value">RDBMS</xsl:attribute>
                           <xsl:if test="$dataSourceType='RDBMS' or $transformDST[@name='org.wso2.ws.dataservice.driver']">
                               <xsl:attribute name="selected">true</xsl:attribute>
                           </xsl:if>
                           RDBMS
                       </option>
					   <option>
                           <xsl:attribute name="value">EXCEL</xsl:attribute>
                           <xsl:if test="$dataSourceType='EXCEL' or $transformDST[@name='excel_datasource']">
                               <xsl:attribute name="selected">true</xsl:attribute>
                           </xsl:if>
                           MS Excel(97-2003)
                       </option>
					   <option>
                           <xsl:attribute name="value">CSV</xsl:attribute>
                           <xsl:if test="$dataSourceType='CSV' or $transformDST[@name='csv_datasource']">
                               <xsl:attribute name="selected">true</xsl:attribute>
                           </xsl:if>
                           CSV
                       </option>
					   <option>
                           <xsl:attribute name="value">JNDIDataSource</xsl:attribute>
                           <xsl:if test="$dataSourceType='JNDIDataSource' or $transformDST[@name='jndi_context_class']">
                               <xsl:attribute name="selected">true</xsl:attribute>
                           </xsl:if>
                           JNDI Data source
                       </option>
					</select>
                    <input type="button" value="Edit">
                        <xsl:attribute name="onClick">javascript:editStepOne('<xsl:choose>
                            <xsl:when test="$transformDST[@name='org.wso2.ws.dataservice.driver']">
                                 <xsl:text>RDBMS</xsl:text>
                            </xsl:when>
                            <xsl:when test="$transformDST[@name='excel_datasource']">
                                 <xsl:text>EXCEL</xsl:text>
                            </xsl:when>
                            <xsl:when test="$transformDST[@name='csv_datasource']">
                                  <xsl:text>CSV</xsl:text>
                            </xsl:when>
                            <xsl:when test="$transformDST[@name='jndi_context_class']">
                                  <xsl:text>JNDIDataSource</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text/>
                            </xsl:otherwise>
                             </xsl:choose>'); return false;
                        </xsl:attribute>
                    </input>
                </div>
            </fieldset>
        </form>
    </xsl:template>



    <xsl:template name="ds_query">
        <form>
            <fieldset>
                <legend>Queries</legend>
                <xsl:choose>
                    <xsl:when test="count(query)=0">
                        <strong>Currently there are no queries present for the service <font color="blue"><xsl:value-of select="@name"/></font></strong>
                    </xsl:when>
                    <xsl:otherwise>
                        <table class="styled">
                            <thead>
                                <tr>
                                    <th>Query Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:apply-templates select="query"/>
                            </tbody>
                        </table>
                    </xsl:otherwise>
                </xsl:choose>
                <br/>
                <input type="button" onClick="javascript:addNewQuery(); return false;" value="New Query"/>
            </fieldset>
        </form>

        <!--<div id="divDSAddQuery" />-->
    </xsl:template>

    <!--TODO : Marker : This will pass all the query elements that will be fit to table-->
    <xsl:template match="query">
        <tr>
            <td>
                <xsl:value-of select="@id"/>
            </td>
            <td>
                <a alt="Edit">
                    <xsl:attribute name="title">Edit query
                        <xsl:value-of select="@id"/>
                    </xsl:attribute>
                    <xsl:attribute name="onclick">javascript:editExistingQuery('<xsl:value-of select="@id"/>');return false;
                    </xsl:attribute>
                    <xsl:attribute name="id">edit_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
                <a alt="Remove">
                    <xsl:attribute name="title">Remove query
                        <xsl:value-of select="@id"/>
                    </xsl:attribute>
                <xsl:attribute name="onclick">javascript:removeDSQuery('<xsl:value-of select="@id"/>');return false;
                </xsl:attribute>
                    <xsl:attribute name="id">cancel_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
            </td>
        </tr>

    </xsl:template>

    <!-- TODO Fix for operations-->
    <xsl:template name="ds_operation">
        <form>
            <fieldset>
                <legend>Operations</legend>
                <xsl:choose>
                    <xsl:when test="count(operation)=0">
                        <strong>Currently there are no operations present for the service <font color="blue"><xsl:value-of select="@name"/></font></strong>
                    </xsl:when>
                    <xsl:otherwise>
                        <table class="styled">
                            <thead>
                                <tr>
                                    <th>Operation Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:apply-templates select="operation"/>
                            </tbody>
                        </table>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:choose>
                    <xsl:when test="query">
                          <input type="button" onClick="addNewOperationForDataService();return false;" value="Add New Operation"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <div>
                        <br/>
                        <input type="button" onClick="wso2.wsf.Util.alertWarning('Queries are required before adding new operations');" value="Add New Operation" />
                        </div>
                    </xsl:otherwise>
                </xsl:choose>
            </fieldset>
        </form>

        <!--<div id="divDSAddOperation"></div>-->
    </xsl:template>

    <xsl:template match="operation">
        <tr>
            <td>
                <xsl:value-of select="@name"/>
            </td>
            <td>
                <a alt="Edit">
                    <xsl:attribute name="title">Edit Operation<xsl:value-of select="@name"/></xsl:attribute>
                    <xsl:attribute name="onclick">javascript:editDataServiceOperation('<xsl:value-of select="@name"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">edit_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
                <a alt="Remove">
                    <xsl:attribute name="title">Remove Operation<xsl:value-of select="@name"/>
                    </xsl:attribute>
                    <xsl:attribute name="onclick">javascript:dataServiceRemoveOperation('<xsl:value-of select="@name"/>');return false;</xsl:attribute>
                    <xsl:attribute name="id">cancel_link</xsl:attribute>
                    <xsl:attribute name="href">#</xsl:attribute>
                    <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text>
                </a>
            </td>
        </tr>
    </xsl:template>
    
</xsl:stylesheet>
