<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">
    <!-- Template for configuring module parameters-->
    <xsl:output method="html"/>

    <xsl:template match="ns1:getModuleParametersResponse">
        <fieldset style="border:none;">
            <div id="configureModuleHeader" />

        <xsl:choose>
            <xsl:when test="return">
                <div id="moduleConfigUpdate" />

                <!-- Div handling starts from here-->
                <div id="formset">
                    <form>
                        <fieldset>
                            <legend>Edit module specific parameters</legend>
                            <table class="emptyTable">
                                <xsl:for-each select="return">
                                    <xsl:if test="parameter/@name!=''">
                                    <tr style="clear: both;">
                                        <td>
                                            <label style="width:25%;"><xsl:value-of select="parameter/@name"/></label>
                                        </td>
                                        <td>
                                            <input type="text">
                                                    <xsl:attribute name="size">50</xsl:attribute>
                                                    <xsl:attribute name="value"><xsl:value-of select="parameter"/></xsl:attribute>
                                                    <xsl:attribute name="id"><xsl:value-of select="generate-id()"/></xsl:attribute>
                                                    <xsl:attribute name="tabindex">
                                                        <xsl:value-of select="position()"/>
                                                    </xsl:attribute>
                                                    <xsl:if test="@locked='true'">
                                                        <xsl:attribute name="disabled">true</xsl:attribute>
                                                    </xsl:if>
                                            </input>
                                        </td>
                                        <td>
                                            <nobr>
                                                &#160;&#160;
                                                <a href="#" syle="vertical-align: middle;">
                                                    <xsl:attribute name="class">remove_param</xsl:attribute>
                                                    <xsl:attribute name="id"><xsl:value-of select="parameter/@name"/></xsl:attribute>
                                                    <xsl:attribute name="onClick">javascript:removeModuleParameter(this);return false;</xsl:attribute>
                                                    <xsl:attribute name="title">Remove Module Parameter</xsl:attribute>
                                                    <xsl:attribute name="alt">Remove</xsl:attribute>
                                                    &#160;&#160;&#160;&#160;
                                                </a>
                                            </nobr>
                                        </td>
                                        </tr>
                                    </xsl:if>
                                </xsl:for-each>
                            </table>
                            <p>&#160;</p>
                            <div class="buttonrow">
                                <!-- update button -->
                                <input type="button" value="update">
                                    <xsl:attribute name="onClick">javascript:
                                        var arrayOfNames=new Array();
                                        var arrayOfValues=new Array();
                                        <xsl:for-each select="return">
                                            arrayOfNames[<xsl:value-of select="position()-1"/>] = '<xsl:value-of select="parameter/@name"/>';
                                            arrayOfValues[<xsl:value-of select="position()-1"/>] = (document.getElementById('<xsl:value-of select="generate-id()"/>').value);
                                        </xsl:for-each>
                                        processModuleConfigUpdate(arrayOfNames,arrayOfValues);
                                        return false;
                                    </xsl:attribute>
                                </input>
                                <input type="button" value="add">
                                    <xsl:attribute name="onClick">javascript:addModuleParameter();return false;</xsl:attribute>
                                </input>
								<input type="button" onClick="javascript:history.back(); return false;" value="Cancel"/>
                            </div>

                        </fieldset>
                      </form>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div id="moduleConfigUpdate" />
                <!-- end of link header block -->
                <div id="formset">
                    <form>
                        <fieldset>
                            <legend>Parameters</legend>
                                <p>No Module parameters found.</p>
                                <div>
                                    <!-- add button -->
                                    <input type="button" value="add">
                                        <xsl:attribute name="onClick">javascript:addModuleParameter();return false;</xsl:attribute>
                                    </input>
                                </div>
                        </fieldset>
                    </form>
                </div>
            </xsl:otherwise>
        </xsl:choose>

        </fieldset>
    </xsl:template>
</xsl:stylesheet>
