<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">

    <xsl:output method="html"/>

    <xsl:template match="ns1:listMethodsForClassResponse">
        <fieldset style="border:none;">
            <h4><a href="#" onClick="javascript:showServiceInitializer(); return false;">Services</a>&#160;&gt;&#160;<a
                    href="#" onClick="javascript:history.back(); return false">Select POJOs</a>&#160;&gt;&#160;Select Methods</h4>
            <div id="formset">
                <form>
                    <fieldset>
                        <legend>Add methods to deployment</legend>
                        <xsl:choose>
                            <xsl:when test="return">
                                 <!-- Inline table. This would be the easie-->
                                <xsl:variable name="rowCount" select="count(return)"/>
                                <xsl:variable name="startEle">
                                    <xsl:for-each select="return">
                                        <xsl:if test="position() = 1">
                                            <xsl:call-template name="xml-name-to-javascript-name">
                                                <xsl:with-param name="name" select="className"/>
                                            </xsl:call-template>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:variable>
                                <table cellspacing="0" cellpadding="0">
                                    <xsl:for-each select="return">
                                        <xsl:variable name="opName">
                                            <xsl:call-template name="xml-name-to-javascript-name">
                                                <xsl:with-param name="name" select="className"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <tr>
                                            <td class="left-tab"> <!-- TODO ID add stuff should go here-->
                                                <xsl:choose>
                                                    <xsl:when test="position() != 1">
                                                         <a href="#">
                                                             <xsl:attribute name="onClick">javascript:selectClassMethodOperation('<xsl:value-of select="$opName"/>','pojo_id_param_',document.getElementById('pojo_id_param_<xsl:value-of select="$startEle"/>'));return false;</xsl:attribute>
                                                             <xsl:value-of select="className"/>
                                                         </a>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                         <a href="#" onClick="javascript:selectClassMethodOperation('{$opName}','pojo_id_param_');return false;"><xsl:value-of select="className"/></a>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                           <xsl:if test="position() = 1">
                                               <td rowspan="{$rowCount}" class="tab-content">
                                                   <xsl:for-each select="../return">
                                                       <xsl:variable name="divId">
                                                            <xsl:call-template name="xml-name-to-javascript-name">
                                                                <xsl:with-param name="name" select="className"/>
                                                            </xsl:call-template>
                                                        </xsl:variable>
                                                        <div>
                                                            <xsl:choose>
                                                                <xsl:when test="position() = 1">
                                                                     <xsl:attribute name="style">display:block;</xsl:attribute>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                     <xsl:attribute name="style">display:none;</xsl:attribute>
                                                                </xsl:otherwise>
                                                            </xsl:choose>

                                                            <xsl:attribute name="id">pojo_id_param_<xsl:value-of select="$divId"/></xsl:attribute>
                                                            <table cellspacing="0" cellpadding="0">
                                                                <thead>
                                                                    <tr>
                                                                        <th colspan="2">Method to expose as operation</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <xsl:choose>
                                                                        <xsl:when test="methods">
                                                                             <xsl:apply-templates select="methods"/>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <tr>
                                                                                <td colspan="2">No methods are available in the the current class.</td>
                                                                            </tr>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </tbody>
                                                            </table>
                                                        </div>

                                                   </xsl:for-each>
                                               </td>
                                            </xsl:if>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </xsl:when>
                            <xsl:otherwise>
                                <table>
                                    <tr>
                                        <td>No methods are available in the the current class.</td>
                                    </tr>
                                </table>
                            </xsl:otherwise>
                        </xsl:choose>
                        <div class="buttonrow">
                            <input type="button" value="Generate">
                                <xsl:attribute name="onClick">
                                    javascript:
                                    var classMethodsSelectionObject = new Object();

                                    <xsl:choose>
                                        <xsl:when test="return">
                                            <xsl:for-each select="return">
                                                <xsl:variable name="className">
                                                    <xsl:call-template name="xml-name-to-javascript-name">
                                                        <xsl:with-param name="name" select="className"/>
                                                    </xsl:call-template>
                                                </xsl:variable>
                                                classMethodsSelectionObject["<xsl:value-of select="$className"/>"] = "<xsl:value-of select="className"/>";
                                            </xsl:for-each>
                                            generateAARWithSelectedClassesAndMethods(classMethodsSelectionObject,'chk_');
                                        </xsl:when>
                                        <xsl:otherwise>
                                            wso2.wsf.Util.alertWarning("Service archive generation faild");
                                        </xsl:otherwise>
                                    </xsl:choose>


                                    return false;
                                </xsl:attribute>
                            </input>
                        </div>
                    </fieldset>
                </form>
            </div>
        </fieldset>

    </xsl:template>

    <xsl:template match="methods">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="overload='true'">
                        <font color="red">
                            <xsl:value-of select="methodName"/>
                        </font>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="methodName"/>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <input type="checkbox">
                    <xsl:variable name="chkName">
                        <xsl:call-template name="xml-name-to-javascript-name">
                            <xsl:with-param name="name" select="../className"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:if test="overload='true'">
                        <xsl:attribute name="disabled">true</xsl:attribute>
                    </xsl:if>
                    <xsl:attribute name="name">chk_<xsl:value-of select="$chkName"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="methodName"/></xsl:attribute>
                    <xsl:if test="overload='false'">
                        <xsl:attribute name="checked">true</xsl:attribute>
                    </xsl:if>
                </input>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="xml-name-to-javascript-name">
        <xsl:param name="name"/>
        <xsl:value-of select="translate($name,'.-','__')"/>
    </xsl:template>

</xsl:stylesheet>