/*
system.js is contains scripts to handle home, system
*/

var ADMIN_SERVER_URL = "ServerAdmin";
var SHOW_HOME_REFRESH_TIME = 6000;

var showDivHome = false;
var showDivHomeTimeout;
var showHomeInterval = 0;
var javaVersion;

function showHomeMenu(thisObj, index) {

    renderHomeMenuExplicitly();
    //Initial Firing
    if (showHomeInterval == 0) {
        showHome();
        showHomeInterval = setInterval('showHome()', SHOW_HOME_REFRESH_TIME);
    }
}

function showGeneralHome() {
    renderGeneralHomeMenueExplicitly();
    var divId = document.getElementById('divGeneralHome');
    if (divId) {
        wso2.wsf.Util.showOnlyOneMain(divId);
    }
}

function showHome() {

    var body_xml = ' <ns1:getStatus  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';
    var callURL = serverURL + "/" + SERVER_ADMIN_STRING + "/" + "getStatus";

    if (document.getElementById("divHome").style.display == 'none' &&
        showDivHome) {
        showDivHome = false;
        clearInterval(showHomeInterval);
        showHomeInterval = 0;
        // this is to counter if focus to divHome is vanished.
        return false;

    }

    new wso2.wsf.WSRequest(callURL,"getStatus",body_xml,showHomeCallback);

}

function showHomeCallback() {
//    stopWaitAnimation();
    javaVersion = this.req.responseXML.getElementsByTagName("javaVersion")[0].firstChild.nodeValue;
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"system_status.xsl", document.getElementById("divHome"));
    showDivHome = true;
    // tivially at this point divHome is inline
}

function manageSystem(thisObj, index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = ' <ns1:getServerData xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + SERVER_ADMIN_STRING ;
    new wso2.wsf.WSRequest(callURL,"getServerData",body_xml,manageSystem["callback"]);

}

manageSystem["callback"] = function() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"system_info.xsl",document.getElementById("divManageSystem"));
}

function saveServer() {
    var body_xml = '<req:saveRequest xmlns:req="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + ADMIN_SERVER_URL ;
    new wso2.wsf.WSRequest(callURL, "save", body_xml, function() {
        wso2.wsf.Util.alertMessage("Server state was saved successfuly");
    });
}

function storeCurMenu(thisObj, index) {
    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }
}

function wsasPing() {
    var bodyXML = '<req:ping xmlns:req="http://org.apache.axis2/xsd"/>\n';
    var callURL = serverURL + "/" + "GlobalAdmin" ;
    var req = new WSRequest();
    var options = new Object();
    options["useBindng"] = "SOAP 1.1";
    options["action"] = "urn:ping";

    try {
        req.open(options, callURL, false);
        req.send(bodyXML);
        var response = req.responseText;
        if (!response){
            return false;
        }
        if (response.length == 0) {
            return false;
        }
        if (response.indexOf("true") > -1) {
            return true;
        }
    }catch(e) {
        return false;
    }

}