/*Administration service of the WSO2WSAS-SecurityTokenService*/

function getTrustedServices() {
    var bodyXML = '<req:getTrustedServices xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '</req:getTrustedServices>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:getTrustedServices",bodyXML,getTrustedServicesCallback);

}

function getTrustedServicesCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML,"sts_main_info.xsl", document.getElementById("divSTS"));
    showSTSHeader(document.getElementById('genericScenarioHeader'));

    //populate cert aliases
    getCertAliasOfPrimaryKeyStore();

}


function getCertAliasOfPrimaryKeyStore() {
    var bodyXML = '<req:getCertAliasOfPrimaryKeyStore xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '</req:getCertAliasOfPrimaryKeyStore>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL, "urn:getCertAliasOfPrimaryKeyStore", bodyXML, getCertAliasOfPrimaryKeyStoreCallback);
}

function getCertAliasOfPrimaryKeyStoreCallback() {
    var comboToLoad = document.getElementById('certAliasSelectBoxId');
    var data = this.req.responseXML;
    var rets = data.getElementsByTagName("return");
    var len = rets.length;
    var count;
    for (count = 0; count < len; count++) {
        comboToLoad.options[count] = new Option(rets[count].firstChild.nodeValue);
        comboToLoad.options[count].value = rets[count].firstChild.nodeValue;
    }

//    getProofKeyType();
}

function addTrustedService() {
    var eprObjId = document.getElementById('endpointAddressId');
    var caObjId = document.getElementById('certAliasSelectBoxId');
    var caselectedValue = caObjId[caObjId.selectedIndex].value;
    var eprValue = eprObjId.value;

    if (eprValue == null || eprValue.length == 0) {
        wso2.wsf.Util.alertMessage("Please select an endpoint address to trust.");
        return false;
    }

    var bodyXML = '<req:addTrustedService xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '<serviceAddress>'+ eprValue+ '</serviceAddress>\n' +
                  '<certAlias>' + caselectedValue + '</certAlias>' +
                  '</req:addTrustedService>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:addTrustedService",bodyXML,function() {
        wso2.wsf.Util.alertMessage("Endpoint address to be trusted has successfully added");
        getTrustedServices();
    });

}

function setProofKeyType() {
    var pktObj = document.getElementById('proofKeyTypeSelectBoxId');
    var pktSelectedValue = pktObj[pktObj.selectedIndex].value;

    var bodyXML = '<req:setProofKeyType xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '<keyType>'+ pktSelectedValue+ '</keyType>\n' +
                  '</req:setProofKeyType>\n';
    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:setProofKeyType",bodyXML,function() {
        wso2.wsf.Util.alertMessage("Proof Key Type successfully added.");
        getTrustedServices();
    });
}

function getProofKeyType() {
    var bodyXML = '<req:getProofKeyType xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '</req:getProofKeyType>\n';

    var callURL = serverURL + "/" + "STSAdmin" ;
    new wso2.wsf.WSRequest(callURL,"urn:getProofKeyType",bodyXML,getProofKeyTypeCallback);

}

function getProofKeyTypeCallback() {
    var comboToLoad = document.getElementById('proofKeyTypeSelectBoxId');
    var data = this.req.responseXML;
    var ret = data.getElementsByTagName("return")[0];

    var value = ret.firstChild.nodeValue;
    if (value == 'EncryptedKey') {
        comboToLoad[0] = new Option('EncryptedKey', 'EncryptedKey');
        comboToLoad[1] = new Option('BinarySecret', 'BinarySecret');

    } else if (value == 'BinarySecret') {
        comboToLoad[0] = new Option('BinarySecret', 'BinarySecret');
        comboToLoad[1] = new Option('EncryptedKey', 'EncryptedKey');
    }

}

