/*
Security Handling
*/

function dynamicallyLoadSecurityJs() {

    var rampartConfigObj = document.getElementById('rampartConfigId');
    var rampartConfigTransformerHelperObj = document.getElementById('rampartConfigTransformerHelperId');

    if ((rampartConfigObj == null) && (rampartConfigTransformerHelperObj == null)) {
        var script1 = document.createElement('script');
        script1.id = "rampartConfigId";
        script1.type = 'text/javascript';
        script1.src = 'extensions/core/js/rampart_config.js';
        document.getElementsByTagName('head')[0].appendChild(script1);

        var script2 = document.createElement('script');
        script2.id = "rampartConfigTransformerHelperId";
        script2.type = 'text/javascript';
        script2.src = 'extensions/core/js/rampart_specific_transformer.js';
        document.getElementsByTagName('head')[0].appendChild(script2);
    }
}


function showSecurityConfigurationInfo() {

    /*stopping the refreshing first */
    stoppingRefreshingMethodsHook();

    dynamicallyLoadSecurityJs();

    var body_xml = '<req:getScenarios xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceName>'+getServiceSpecificName()+'</serviceName>' +
                   '</req:getScenarios>';

    var callURL = serverURL + "/" + SECURITY_SCENARIO_CONFIG_ADMIN + "/" ;
    new wso2.wsf.WSRequest(callURL,"getScenarios",body_xml,showSecurityConfigurationInfoCallback);
}

function showSecurityConfigurationInfoCallback() {

    /*var data = getBody(xhReq.responseXML);
    alert(xmlSerializerToString(data));*/

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_security_main_info.xsl",document.getElementById('divSecurityConfiguration'));
    showConfigurationSecenarios(document.getElementById('headerListSecurity'));
}

// Timestamp configuratation with Objects

function TimeStamp() {
    this.serviceId = '';
    this.operationSOAPAction = '';
    this.tsFirst = true;
}
//setters
TimeStamp.prototype.setServiceId = function(serviceId) {
    this.serviceId = serviceId;
}

TimeStamp.prototype.setOperationSOAPAction = function(operationSOAPAction)  {
    this.operationSOAPAction = operationSOAPAction;
}

TimeStamp.prototype.setTsFirst = function(tsFirst) {
    this.tsFirst = tsFirst;
}

// getters
TimeStamp.prototype.getServiceId = function() {
    return this.serviceId
}

TimeStamp.prototype.getOperationSOAPAction = function()  {
    return this.operationSOAPAction;
}

TimeStamp.prototype.getTsFirst = function() {
    return this.tsFirst;
}

function showTimsStampMainInfo(){
//TODO maiking divs independent and generaic
    var objDiv = document.getElementById('divTimestampConfig');

    var strInnerHtml ="<div id='timestampHeader'></div>"+
                      "<h2>Timestamp Configuration</h2>"+
                      "<fieldset style='border:none;'>"+
                      "<div id='formset'>"+
                      "<form>"+
                      "<fieldset>"+
                      "<legend>Inflow Configuration</legend>"+
                      "<div id='inflow_configuration_setting' />"+
                      "</fieldset>"+
                      "</form>"+
                      "<form>" +
                      "<fieldset>"+
                      "<legend>Outflow Configuration</legend>" +
                      "<div id='outflow_configuration_setting' />"+
                      "</fieldset>"+
                      "</form>"+
                      "</div>"+
                      "</fieldset>";
    objDiv.innerHTML = "";
    objDiv.innerHTML = strInnerHtml;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    //starting with ts inflow configuration
    showTSInflowConfiguration();

}

function showTSInflowConfiguration() {
    var body_xml = '<req:enableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceId>'+ getServiceSpecificName() +'</serviceId>'+
                   '<operationSOAPAction></operationSOAPAction>'+
                   '</req:enableTimestampRequest>';

   var callURL = serverURL + "/" + RAMPART_INFLOW_CONFIG_ADMIN_STRING + "/" ;
    new wso2.wsf.WSRequest(callURL,"enableTimestamp",body_xml,showTSInflowConfigurationCallback);
}

function showTSInflowConfigurationCallback() {

    transformationWithoutHistory(this.req.responseXML,"timestamp_inflow_config.xsl", document.getElementById("inflow_configuration_setting"));

    showTSOutflowConfiguration();

}

function disableTimeStampConfig(rampartFlowString,flowCallback,flow) {
    var body_xml;
    if (flow == 1) {
        body_xml =     '<req:disableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '</req:disableTimestampRequest>';
    }else if (flow == 2) {
        body_xml =     '<req:disableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '<repetition>0</repetition>'+
                       '</req:disableTimestampRequest>';
    }

   var callURL = serverURL + "/" + rampartFlowString + "/" ;
    new wso2.wsf.WSRequest(callURL,"disableTimestamp",body_xml,flowCallback);

}

function showTSOutflowConfiguration() {
    var body_xml = '<req:enableTimestampRequest xmlns:req="http://org.apache.axis2/xsd">' +
                   '<serviceId>'+ getServiceSpecificName() +'</serviceId>'+
                   '<operationSOAPAction></operationSOAPAction>'+
                   '<repetition>0</repetition>'+ // TODO Zero is hard coded need to chage for different values
                   '</req:enableTimestampRequest>';

   var callURL = serverURL + "/" + RAMPART_OUTFLOW_CONFIG_ADMIN_STRING + "/" ;
    new wso2.wsf.WSRequest(callURL,"enableTimestamp",body_xml,showTSOutflowConfigurationCallback);

}

function showTSOutflowConfigurationCallback() {

    transformationWithoutHistory(this.req.responseXML,"timestamp_outflow_config.xsl", document.getElementById("outflow_configuration_setting"));

    showTimeStampDiv(document.getElementById('timestampHeader'));
}

function showTSOutflowConfigurationDivCallback() {
    transformationWithoutHistory(this.req.responseXML,"timestamp_outflow_config.xsl", document.getElementById("outflow_configuration_setting"));
}

//flow - 1 : inflow ; 2 : outflow
function timestampFlowConfig(checkboxObj, flow) {
    if (checkboxObj.checked) {
        //callfor showTimestampConfiguration();
        if (flow == 1) {
            showTSInflowConfiguration();
        } else if (flow == 2) {
            showTSOutflowConfiguration();
        }
        return true;
    } else {

        if (flow == 1){
           disableTimeStampConfig(RAMPART_INFLOW_CONFIG_ADMIN_STRING,showTSInflowConfigurationCallback,flow);
        } else if (flow == 2) {
           disableTimeStampConfig(RAMPART_OUTFLOW_CONFIG_ADMIN_STRING,showTSOutflowConfigurationDivCallback,flow);
        }
        // callfor disableTimeStampConfig();
        return true;
    }

}

//callbacks to disableTimeStampConfig()

function disableTimeStampConfigInflowCallback() {
   if (!onError()) {
        return;
   }

}

function setTimestampOrder(rampartFlowString,booleanValue,flow,flowCallback) {
    var body_xml;
    if (flow == 1) {
        body_xml =     '<req:setTimestampOrderRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '<tsFirst>'+booleanValue+'</tsFirst>'+
                       '</req:setTimestampOrderRequest>' ;
    }else if (flow == 2) {
        body_xml =     '<req:setTimestampOrderRequest xmlns:req="http://org.apache.axis2/xsd">' +
                       '<serviceId>' + getServiceSpecificName() + '</serviceId>' +
                       '<operationSOAPAction></operationSOAPAction>' +
                       '<repetition>0</repetition>'+
                       '<tsFirst>'+booleanValue+'</tsFirst>'+
                       '</req:setTimestampOrderRequest>';
    }

   var callURL = serverURL + "/" + rampartFlowString + "/" ;
    new wso2.wsf.WSRequest(callURL,"setTimestampOrder",body_xml,flowCallback);

}



