/*
This JS holds classes for transformation that is specifically wirtten to
support rampart configurations. This will be loaded as demanded.
*/

var rampartExtensionPath = "rampart";

function rampartSpecificTransformationWithoutHistory(xmlDoc,xslFile, objDiv, paramArray) {
    rampartSpecificTransformer(xmlDoc, xslFile, objDiv, false, paramArray);
    wso2.wsf.Util.showOnlyOneMain(objDiv, true);
}

function rampartSpecificTransformer(xml, xslFileName, objDiv, isAbsPath, paramArray) {

    var xsltTransformer = new wso2.wsf.XSLTHelper();
    var path = "extensions/core/xslt/" + rampartExtensionPath + "/" + xslFileName;
    if (paramArray) {
        xsltTransformer.transform(objDiv, xml, path, true, false, [["topLevelHeading",paramArray[0]]]);
    } else {
        xsltTransformer.transform(objDiv, xml, path, true);
    }

}

function mozillaSpecificXSLLoader(xslFileName) {
    /*xslProcessor variable is avaiable from wso2_adminui */
    xsltProcessor = new XSLTProcessor();
    var p = createXMLHttpRequest();
    var fullPath = URL + "/extensions/core/xslt/" + rampartExtensionPath + "/" + xslFileName;
    p.open("GET", fullPath, false);
    p.send(null);

    var xslRef = p.responseXML;
    xsltProcessor.importStylesheet(xslRef);
}

function ieSpecificXSLLoader(xml, fileName, objDiv, paramArray) {
    var fullPath = URL + "/extensions/core/xslt/" + rampartExtensionPath + "/" + fileName;
    transformXMLIE(xml, fullPath, objDiv, paramArray);
}

function transformXMLIE(xmlDoc, xslDocURL, objDiv, paramArray)
{
    // declare the local variables
    var xslDoc, docProcessor, docCache, DocRequest, docFragment;
    // try the following
    try
    {
        // instantiate and load the xsl document
        xslDoc = new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
        xslDoc.async = false;
        xslDoc.load(xslDocURL);
        // prepare the xsl document for transformation
        docCache = new ActiveXObject("MSXML2.XSLTemplate");
        docCache.stylesheet = xslDoc;
        // instantiate the document processor and submit the xml document
        docProcessor = docCache.createProcessor();
        docProcessor.input = xmlDoc;
        // add parameters to the xsl document
        if (paramArray) {
            docProcessor.addParameter("topLevelHeading", paramArray[0], "");
        }
        // process the documents into html and submit to the passed div to the HMTL page
        docProcessor.transform();
        // divID.innerHTML = docProcessor.output;
        objDiv.innerHTML = "<div>" + docProcessor.output + "</div>";
    }
    // catch any errors from the above code
    catch(e) {
        alert("Encounterd an error  : " + e);
    }
}

