function getSelectedValue(comboBoxName) {
    comboBox = document.getElementById(comboBoxName);
    comboBoxValue = comboBox[comboBox.selectedIndex].value;
    return comboBoxValue;
}

function setSelectedValue(comboBoxName, selectedValue) {
    comboBox = document.getElementById(comboBoxName);
    var len = comboBox.options.length;
    for (i = 0; i < len; i += 1) {
        if (comboBox.options[i].value == selectedValue) {
            comboBox.selectedIndex = i;
        }
    }
}

function systemLogConfig(thisObj, index) {
    if (thisObj && index) {
        renderSelectedMenuItem(thisObj, index);
        gatherHistoryObject(thisObj.id, index);
    }
    var bodyXml = '<req:getSystemLogRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' </req:getSystemLogRequest>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getSystemLog", bodyXml, systemLogConfigCallback);
}

function systemLogConfigCallback() {
    wso2.wsf.Util.callbackhelper(this.req.responseXML, "log1.xsl", document.getElementById("divSystemConfiguration"));
    //Load the loggers
    var bodyXml =  '<req:getAllLoggerData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   '<logNameFilter nillable="true"></logNameFilter>\n'+
                   '<beginsWith>false</beginsWith>\n'+
                   '</req:getAllLoggerData>\n';
    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "urn:getAllLoggerData", bodyXml, function() {
        transformationWithoutHistory(this.req.responseXML, "log2.xsl", document.getElementById("divLogConfig.loggers"));
    });
}

function showLoggers(logNameFilter, beginsWith){
    if(beginsWith == null){
        beginsWith = false;
    }
    var body_xml = '<req:getAllLoggerData xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:logNameFilter>' + logNameFilter + '</req:logNameFilter>\n' +
                   ' <req:beginsWith>' + beginsWith + '</req:beginsWith>\n' +
                   '</req:getAllLoggerData>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getAllLoggerData", body_xml, showLoggersCallback);
}

function showLoggersCallback(){
    transformationWithoutHistory(this.req.responseXML, "log2.xsl", document.getElementById("divLogConfig.loggers"));
}

function updateLoggerData() {

    var loggerName = getSelectedValue("loggerNameSettingCombo");
    var body_xml = '<req:getLoggerDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:loggerName>' + loggerName + '</req:loggerName>\n' +
                   ' </req:getLoggerDataRequest>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    new wso2.wsf.WSRequest(callURL, "getLoggerData", body_xml, updateLoggerDataCallBack);
}

function updateLoggerDataCallBack() {

    var logLevelCombBox = document.getElementById("loggerLogLevelSettingCombo");
    //alert(prettyPrintDOMNode(xhReq.responseXML));
    var logLevel = this.req.responseXML.getElementsByTagName("level");
    var logLevelStr = logLevel[0].firstChild.nodeValue;
    var len = logLevelCombBox.options.length;
    for (i = 0; i < len; i += 1) {
        if (logLevelCombBox.options[i].value == logLevelStr) {
            logLevelCombBox.selectedIndex = i;
        }
    }

    var additivityElemet = this.req.responseXML.getElementsByTagName("aditivity");
    var additivity = additivityElemet[0].firstChild.nodeValue;
    var additivityCoboBox = document.getElementById("loggerAdditiviySettingCombo");
    if (additivity == 'true') {
        additivityCoboBox.selectedIndex = 0;
    } else {
        additivityCoboBox.selectedIndex = 1;
    }

}

function updateAppenderData() {

    var appenderName = getSelectedValue("appeanderNameSettingCombo");
    var body_xml = '<req:getAppenderDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:appenderName>' + appenderName + '</req:appenderName>\n' +
                   ' </req:getAppenderDataRequest>\n';

    var callURL = serverURL + "/" + "LoggingAdmin" ;

    new wso2.wsf.WSRequest(callURL, "getAppenderData", body_xml, updateAppenderDataCallback);
}


/* updates the appender text in text box*/

function updateAppenderDataCallback() {


    var patternInputBox = document.getElementById("appenderLogPatternField");
    var logPattern = this.req.responseXML.getElementsByTagName("pattern");
    var logFile = this.req.responseXML.getElementsByTagName("logFile");
    patternInputBox.value = logPattern[0].firstChild.nodeValue;

    // set the threshold
    var threshold = this.req.responseXML.getElementsByTagName("threshold");
    setSelectedValue("appenderThresholdCombo", threshold[0].firstChild.nodeValue)

    var appenderLogFileDiv = document.getElementById("appenderLogFileDiv");
    var appenderSysLogDiv = document.getElementById("appenderSysLogDiv");

    var appenderIsFileAppenderElement = this.req.responseXML.getElementsByTagName("isFileAppender");
    var appenderIsFileAppender = appenderIsFileAppenderElement[0].firstChild.nodeValue;

    if (appenderIsFileAppender == 'true') {
        appenderLogFileDiv.style.display = "inline";
        var logFileInputBox = document.getElementById("appenderLogFile");
        logFileInputBox.value = logFile[0].firstChild.nodeValue;
    } else {
        appenderLogFileDiv.style.display = "none";
    }

    var appenderIsSysLogAppenderElement = this.req.responseXML.getElementsByTagName("isSysLogAppender");
    var appenderIsSysLogAppender = appenderIsSysLogAppenderElement[0].firstChild.nodeValue;

    if (appenderIsSysLogAppender == 'true') {
        appenderSysLogDiv.style.display = "inline";
        // set sysLog host
        var sysLogHost = this.req.responseXML.getElementsByTagName("sysLogHost");
        var sysLogHostInputBox = document.getElementById("appenderSysLogHost");
        sysLogHostInputBox.value = sysLogHost[0].firstChild.nodeValue;

        // set Facility
        var facility = this.req.responseXML.getElementsByTagName("facility");
        setSelectedValue("appenderFacilitySettingCombo", facility[0].firstChild.nodeValue)
    } else {
        appenderSysLogDiv.style.display = "none";
    }
}

function storeAppenderData() {

    var appenderName = getSelectedValue("appeanderNameSettingCombo");
    var appenderPattern = document.getElementById("appenderLogPatternField").value;
    var threshold = getSelectedValue("appenderThresholdCombo");

    var logFileInputBox = document.getElementById("appenderLogFile");
    var sysLogHostInputBox = document.getElementById("appenderSysLogHost");
    var facility = getSelectedValue("appenderFacilitySettingCombo");
    var persist = document.getElementById('persistLogId');

    var body_xml;
    var callURL = serverURL + "/" + "LoggingAdmin" ;

    if (appenderName == "WSO2WSAS_LOGFILE" && wso2.wsf.Util.trim(logFileInputBox.value) == "") {
        wso2.wsf.Util.alertWarning("Please specify a valid log file.");
        return;
    }

    body_xml = '<req:updateAllAppenderDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
               ' <req:appenderName>' + appenderName + '</req:appenderName>\n' +
               ' <req:appenderPattern>' + appenderPattern + '</req:appenderPattern>\n' +
               ' <req:threshold>' + threshold + '</req:threshold>\n' +
               ' <req:logFileName>' + logFileInputBox.value + '</req:logFileName>\n' +
               ' <req:sysLogHost>' + sysLogHostInputBox.value + '</req:sysLogHost>\n' +
               ' <req:facility>' + facility + '</req:facility>\n' +
               ' <req:persist>' + persist.checked + '</req:persist>\n' +
               ' </req:updateAllAppenderDataRequest>\n';

    new wso2.wsf.WSRequest(callURL, "updateAllAppenderData", body_xml, storeAppenderDataCallBack);

}

function storeAppenderDataCallBack() {
    wso2.wsf.Util.alertMessage("Successfully updated appender data.")
}

function storeLoggerData() {

    var loggerName = getSelectedValue("loggerNameSettingCombo");
    var loggerLevel = getSelectedValue("loggerLogLevelSettingCombo");
    var loggerAditivity = getSelectedValue("loggerAdditiviySettingCombo");

    var callURL = serverURL + "/" + "LoggingAdmin" ;
    var body_xml = '<req:updateLoggerDataRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                   ' <req:loggerName>' + loggerName + '</req:loggerName>\n' +
                   ' <req:loggerLevel>' + loggerLevel + '</req:loggerLevel>\n' +
                   ' <req:additivity>' + loggerAditivity + '</req:additivity>\n' +
                   ' </req:updateLoggerDataRequest>\n';

    new wso2.wsf.WSRequest(callURL, "updateLoggerData", body_xml, storeLoggerDataCallBack);
}

function storeLoggerDataCallBack() {
    wso2.wsf.Util.alertMessage("Successfully updated logger data.");
}

/* Will update the log level, patern and file on the server globally. */
function setGlobalLogData() {
    var change = confirm("Do you really want to change the global Log4J configuration?");
    if (change) {
        var logLevel = getSelectedValue("globalLogLevelSettingCombo");
        var logPattern = document.getElementById('globalLogPatternField').value;
        var persist = document.getElementById('persistLogId');

        var body_xml = '<req:updateSystemLogRequest xmlns:req="http://org.apache.axis2/xsd">\n' +
                       ' <logLevel>' + logLevel + '</logLevel>\n' +
                       ' <logPattern>' + logPattern + '</logPattern>\n' +
                       ' <persist>' + persist.checked + '</persist>\n' +
                       ' </req:updateSystemLogRequest>\n';

        var callURL = serverURL + "/" + "LoggingAdmin" ;

        new wso2.wsf.WSRequest(callURL, "urn:updateSystemLog", body_xml, function() {
            wso2.wsf.Util.alertMessage("Global Log4J Configuration successfully updated.");
            systemLogConfig();
        });
    }
}


function restoreDefaults() {
    var restore = confirm("Do you really want to restore the original logging configuration?");

    if (restore) {
        var body_xml = '<req:restoreDefaults xmlns:req="http://org.apache.axis2/xsd">\n' +
                       '</req:restoreDefaults>\n';
        var callURL = serverURL + "/" + "LoggingAdmin" ;
        new wso2.wsf.WSRequest(callURL, "restoreDefaults", body_xml, restoreDefaultsCallback);
    }
}

function restoreDefaultsCallback() {
    wso2.wsf.Util.alertMessage("Successfully restored default logging configuration.");
    systemLogConfig();
}

function updateLogParams(name, level, additivity, persist, stat) {

    var bodyXml = '<req:updateLoggerData xmlns:req="http://org.apache.axis2/xsd">\n' +
                  '<loggerName><![CDATA[' + name + ']]></loggerName>\n' +
                  '<loggerLevel>' + level + '</loggerLevel>\n' +
                  '<additivity>' + additivity + '</additivity>\n' +
                  '<persist>' + persist + '</persist>\n' +
                  '</req:updateLoggerData>\n';
    var callURL = serverURL + "/" + "LoggingAdmin" ;

    if (stat == 1) {
        new wso2.wsf.WSRequest(callURL, "urn:updateLoggerData", bodyXml, function() {
//            wso2.wsf.Util.alertMessage("Effective Level has been successfully updated.");
        });
    }

    if (stat == 2) {
        new wso2.wsf.WSRequest(callURL, "urn:updateLoggerData", bodyXml, function() {
//            wso2.wsf.Util.alertMessage("Additivity has been successfully changed.");
        });
    }

}