/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.wso2.wsas.sample.xkms.demo;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import org.wso2.wsas.sample.xkms.locate.LocateServiceDemo;
import org.wso2.wsas.sample.xkms.recover.RecoverServiceDemo;
import org.wso2.wsas.sample.xkms.register.RegisterServiceDemo1;
import org.wso2.wsas.sample.xkms.register.RegisterServiceDemo2;
import org.wso2.wsas.sample.xkms.reissue.ReissueServiceDemo;
import org.wso2.wsas.sample.xkms.validate.ValidateServiceDemo;

public class XKMSServiceDemo {
    
    public static void main(String[] args) throws Exception {
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader bufReader = new BufferedReader(isr);
        
        printUsage();
        
        String line;
        while (true) {
            System.out.println("Enter your choice :");
            line = bufReader.readLine();
            if ("1".equals(line)) {
                RegisterServiceDemo1.main(null);
            } else if ("2".equals(line)) {
                RegisterServiceDemo2.main(null);
            } else if ("3".equals(line)) {
                ReissueServiceDemo.main(null);
            } else if ("4".equals(line)) {
                RecoverServiceDemo.main(null);
            } else if ("5".equals(line)) {
                LocateServiceDemo.main(null);
            } else if ("6".equals(line)) {
                ValidateServiceDemo.main(null);
            } else if ("7".equals(line)) {
                break;
            } else {
                System.out.println("Invalid Option");
            }
        }
        
    }
    
    private static void printUsage() {
        System.out.println("[1] Run Registration Servcie Demo (1)");
        System.out.println("[2] Run Registration Servcie Demo (2)");
        System.out.println("[3] Run Reissue Service Demo");
        System.out.println("[4] Run Recovery Service Demo");
        System.out.println("[5] Run Locate Service Demo");
        System.out.println("[6] Run Validate Service Demo");
        System.out.println("[7] Exit");
        
        
    }
}
