/*
 * Copyright 2001-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.wsas.sample.mex.service.example3;

import java.io.ByteArrayInputStream;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.OutputForm;

public class CustomWSDLLocator implements AxisDataLocator {

    private String wsdlString = "<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\">"
    		+ "<wsdl:documentation>This is a dummy WSDL generated by the CustomWSDLLocator in Example 3.</wsdl:documentation> "
            + "</wsdl:definitions>";

    public Data[] getData(DataRetrievalRequest request,
            MessageContext msgContext) throws DataRetrievalException {
        OutputForm outputForm = request.getOutputForm();
        if (outputForm == null) {
            outputForm = OutputForm.INLINE_FORM;
        }
        
        Data[] data = null;
        
        if (outputForm.equals(OutputForm.INLINE_FORM)) {
            try {
                OMElement customWSDLElement = getCustomWSDLElement();
                data = new Data[] { new Data(customWSDLElement, null) };
        
            } catch (Exception e) {
                throw new DataRetrievalException(e);
            }
            
        } else if (outputForm.equals(OutputForm.LOCATION_FORM)) {
            String address = msgContext.getTo().getAddress();
            data = new Data[] {new Data(address + "?wsdl", null)};
            
        } else if (outputForm.equals(OutputForm.REFERENCE_FORM)) {
            data =new Data[] {};
        }
        
        return data;
    }

    private OMElement getCustomWSDLElement() throws XMLStreamException,
            FactoryConfigurationError {
    	
        return (new StAXOMBuilder(OMAbstractFactory.getOMFactory(),
                XMLInputFactory.newInstance().createXMLStreamReader(
                        new ByteArrayInputStream(wsdlString.getBytes()))))
                .getDocumentElement();

    }

}
