/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.wso2.wsas.sample.jaxws.calculator.client;

import org.wso2.wsas.sample.jaxws.calculator.CalculatorServiceStub;
import org.wso2.wsas.sample.jaxws.calculator.Add;
import org.wso2.wsas.sample.jaxws.calculator.AddResponse;

import java.rmi.RemoteException;
import java.util.Random;

/**
 * JAXWS Calculator Client
 */
public class CalculatorClient {

    public static void main(String[] args) {
        try {
            //Instantiate the Calculator Stub
            CalculatorServiceStub stub = new CalculatorServiceStub();
            doAdd(stub);
        } catch (Exception e) {
            e.printStackTrace();  
        }
    }

    /**
     * Invoke the Calculator Service Add
     */
    private static void doAdd(CalculatorServiceStub stub) throws RemoteException {
        
        //Generate two random values between 0 to 100
        Random rand = new Random();
        int value1 = rand.nextInt(100+1);
        int value2 = rand.nextInt(100+1);

        //Invoke
        Add add = new Add();
        add.setValue1(value1);
        add.setValue2(value2);

        AddResponse res = stub.add(add);
        System.out.println("Results of Addition of "+
                value1 + " with " + value2 + " is : " + res.get_return());

    }
    
}
