/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.sample.ejbservice;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.util.XMLPrettyPrinter;

public class EJBServiceClient{
	private static EndpointReference targetEPR = new EndpointReference(
			"http://localhost:9762/services/TimeServiceRemote");

	public static void main(String args[]) {
		try {
			getServerTime();
		} catch (Exception exception) {
			exception.printStackTrace();
		}
	}
	
	private static void getServerTime() throws Exception {
		Options options1 = new Options();
		options1.setTo(targetEPR);
		options1.setAction("urn:getServerTime");

		ServiceClient sender1 = new ServiceClient();
		sender1.setOptions(options1);
		
 		OMElement payload1 = getServerTimePayload();
		OMElement result1 = sender1.sendReceive(payload1);
		System.out.println("\n\nRequesting Server time...\n");
		
		XMLPrettyPrinter.prettify(result1, System.out);		
	}
	
	private static OMElement getServerTimePayload() {
		OMFactory fac = OMAbstractFactory.getOMFactory();
		OMNamespace omNs = fac.createOMNamespace(
				"http://example1.org/example1", "example1");
		OMElement method = fac.createOMElement("getServerTime", omNs);
		return method;
	}	
}
