/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.sample.dataservice;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.util.XMLPrettyPrinter;

public class DataServiceClient1 {
	private static EndpointReference targetEPR = new EndpointReference(
			"http://localhost:9762/services/DataServiceSample1");

	public static void main(String args[]) {
		try {
			testCustomerContactDetails();
			testEmployeeContactDetailsByNumber();
			testCustomerAddress();
			
		} catch (Exception exception) {
			exception.printStackTrace();
		}
	}
	
	private static void testCustomerContactDetails() throws Exception {
		Options options1 = new Options();
		options1.setTo(targetEPR);
		options1.setAction("urn:customersInBoston");

		ServiceClient sender1 = new ServiceClient();
		sender1.setOptions(options1);
		
		OMElement payload1 = getCustomerContactDetailsPayload();
		OMElement result1 = sender1.sendReceive(payload1);
		System.out.println("\n\nRequesting contact details of customers in Boston...\n");
		
		XMLPrettyPrinter.prettify(result1, System.out);		
	}
	
	private static OMElement getCustomerContactDetailsPayload() {
		OMFactory fac = OMAbstractFactory.getOMFactory();
		OMNamespace omNs = fac.createOMNamespace(
				"http://example1.org/example1", "example1");
		OMElement method = fac.createOMElement("contactDetailsOfCustomersInBoston", omNs);
		return method;
	}
	
	private static void testEmployeeContactDetailsByNumber() throws Exception {
		Options options2 = new Options();
		options2.setTo(targetEPR);
		options2.setAction("urn:employeesByNumber");

		ServiceClient sender2 = new ServiceClient();
		sender2.setOptions(options2);
		
		System.out.println("\n\nRequesting employee contact details for employee number 1002...\n");
		OMElement payload2 = getEmployeeContactDetailsByNumberPayload();
		OMElement result2 = sender2.sendReceive(payload2);
		
		XMLPrettyPrinter.prettify(result2, System.out);
	}
	
	private static OMElement getEmployeeContactDetailsByNumberPayload() {
		OMFactory fac = OMAbstractFactory.getOMFactory();
		OMNamespace omNs = fac.createOMNamespace(
				"http://example1.org/example1", "example1");
		OMElement method = fac.createOMElement("employeeContactDetailsByNumber", omNs);
		OMElement param1 = fac.createOMElement("employeeNumber", omNs);
		param1.setText("1002");
		method.addChild(param1);
		return method;
	}

	private static void testCustomerAddress() throws Exception {
		Options options2 = new Options();
		options2.setTo(targetEPR);
		options2.setAction("urn:customerAddress");

		ServiceClient sender2 = new ServiceClient();
		sender2.setOptions(options2);
		
		System.out.println("\n\nRequestinng customer address for Jean King...\n");
		OMElement payload2 = getCustomerAddressPayload();
		OMElement result2 = sender2.sendReceive(payload2);
		
		XMLPrettyPrinter.prettify(result2, System.out);
	}
	
	private static OMElement getCustomerAddressPayload() {
		OMFactory fac = OMAbstractFactory.getOMFactory();
		OMNamespace omNs = fac.createOMNamespace(
				"http://example1.org/example1", "example1");
		OMElement method = fac.createOMElement("customerAddress", omNs);

		OMElement param1 = fac.createOMElement("firstName", omNs);
		param1.setText("Jean");
		method.addChild(param1);

		OMElement param2 = fac.createOMElement("lastName", omNs);
		param2.setText("King");
		method.addChild(param2);

		return method;
	}
}
