<!--
  ~ Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
  ~
  ~ Licensed under the Apache License, Version 2.0 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
        <h2>Polls</h2>
        <fieldset style="border:none;">
        <xsl:choose>
            <xsl:when test="return">
        <table class="styled">
        	<thead>
            <tr>
                <th>Poll Title</th>
                <th>Description</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
			</thead>
			<tbody>
            <xsl:for-each select="return">
				<xsl:sort select="title"/>
				<tr>
					<td>
						<a>
							<xsl:attribute name="href">#</xsl:attribute>
							<xsl:attribute name="onClick">javascript:wso2.wsas.Chad.static.viewPollDetails('<xsl:value-of select="pollId"/>'); return false;</xsl:attribute>
							<xsl:value-of select="title"/>
						</a>				
					</td>
                    <td>
						<xsl:value-of select="description"/>
					</td>
                    <td>
						<xsl:choose>
							<xsl:when test="isStopped = 'true'">
								Stopped
							</xsl:when>
							<xsl:when test="isStopped = 'false'">
								Running
							</xsl:when>
						</xsl:choose>
					</td>
                    <td>
						<xsl:choose>
							<xsl:when test="isStopped = 'true'">
								<a>
									<xsl:attribute name="href">#</xsl:attribute>
									<xsl:attribute name="onClick">javascript:wso2.wsas.Chad.static.startPoll('<xsl:value-of select="pollId"/>'); return false;</xsl:attribute>
									<xsl:text>Start</xsl:text>
								</a>
							</xsl:when>
							<xsl:when test="isStopped = 'false'">
								<a>
									<xsl:attribute name="href">#</xsl:attribute>
									<xsl:attribute name="onClick">javascript:wso2.wsas.Chad.static.stopPoll('<xsl:value-of select="pollId"/>'); return false;</xsl:attribute>
									<xsl:text>Stop</xsl:text>
								</a>&#160;&#160;
								<a>
									<xsl:attribute name="href">#</xsl:attribute>
									<xsl:attribute name="onClick">javascript:wso2.wsas.Chad.static.eligibleForVoting('<xsl:value-of select="pollId"/>'); return false;</xsl:attribute>
									<xsl:text>Vote</xsl:text>
								</a>
							</xsl:when>
						</xsl:choose>
					</td>
				 </tr>
            </xsl:for-each>
            </tbody>
        </table>
        </xsl:when>
            <xsl:otherwise>
                <b><i>No polls present</i></b>
            </xsl:otherwise>

        </xsl:choose>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>
