/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.sample.trader;

import org.apache.axis2.addressing.EndpointReference;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;
import org.wso2.wsas.sample.exchange.client.ExchangeClientMessageReceiverInOut;
import org.wso2.wsas.sample.exchange.client.ExchangeClientStub;
import org.wso2.wsas.sample.exchange.trader.ExchangeTraderMessageReceiverInOut;
import org.wso2.wsas.sample.trader.client.TraderClientMessageReceiverInOut;
import org.wso2.wsas.sample.trader.client.TraderClientStub;
import org.wso2.www.types.exchange.client.GetInfoRequest;
import org.wso2.www.types.exchange.client.GetInfoResponse;
import org.wso2.www.types.exchange.client.MarketInfo;
import org.wso2.www.types.trader.client.*;


public class TraderServiceIntegrationT extends AbstractTestCase {

    private TraderClientStub traderStub;
    private ExchangeClientStub exchangeStub;

    protected void setUp() throws Exception {
        String traderService = "http://" + NetworkUtils.getLocalHostname() + ":" +
                               TestConstants.TESTING_PORT +
                               "/" + ServerConstants.SERVICE_PATH + "/TraderClient";
        String exchangeService = "http://" + NetworkUtils.getLocalHostname() + ":" +
                                 TestConstants.TESTING_PORT +
                                 "/" + ServerConstants.SERVICE_PATH + "/ExchangeClient";
        EndpointReference trader = new EndpointReference(traderService);
        EndpointReference exchange = new EndpointReference(exchangeService);
        testConnect(trader);
        removeProperties();
        traderStub = new TraderClientStub(trader.getAddress());
        testConnect(exchange);
        exchangeStub = new ExchangeClientStub(exchange.getAddress());

    }

    public void testDoCreateAccountWithoutQOS() throws Exception {
        CreateAccountRequest createAccountRequest = new CreateAccountRequest();
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setName("test123");
        clientInfo.setSsn("NotNeeded");
        createAccountRequest.setClientinfo(clientInfo);
        createAccountRequest.setPassword("test123");

        CreateAccountResponse response = traderStub.createAccount(createAccountRequest);

        assertNotNull(response);
        assertEquals("test123", response.getUserid());

    }

    public void testDoGetQuoteWithoutQOS() throws Exception {
        GetQuoteRequest getQuoteRequest = new GetQuoteRequest();
        getQuoteRequest.setSymbol("mn");

        GetQuoteResponse response = traderStub.getQuote(getQuoteRequest);

        assertNotNull(response);
        StockQuote stockQuote = response.getStock_quote();

        assertEquals(stockQuote.getName(), "mn");
        assertEquals(stockQuote.getSymbol(), "Manganese");

    }

    public void testDoGetSymbolsWithoutQOS() throws Exception {

        GetSymbolsRequest request = new GetSymbolsRequest();

        GetSymbolsResponse response = traderStub.getSymbols(request);

        assertNotNull(response);
        ArrayOfString arr = response.get_return();
        String[] symbols = arr.getValue();
        assertEquals(symbols[0], "mn");
        assertEquals(symbols[1], "tm");

    }

    public void testDoDepositWithoutQOS() throws Exception {
        DepositRequest depositRequest = new DepositRequest();
        depositRequest.setUseridr("test123");
        depositRequest.setPassword("test123");
        depositRequest.setAmount(100);

        DepositResponse depositResponse = traderStub.deposit(depositRequest);

        assertNotNull(depositResponse);
    }

    public void testDoBuyWithoutQOS() throws Exception {
        BuyRequest buyRequest = new BuyRequest();
        buyRequest.setUserid("Jivaka");
        buyRequest.setPassword("Jivaka");
        buyRequest.setSymbol("mn");
        buyRequest.setQty(100);

        BuyResponse buyResponse = traderStub.buy(buyRequest);
        assertNotNull(buyResponse);
        TradeStatus tradeStatus = buyResponse.getTrade_status();
        assertTrue(tradeStatus.getStatus());
        assertEquals(tradeStatus.getReason(), "Success");

    }

    public void testDoSellWithoutQOS() throws Exception {
        SellRequest sellRequest = new SellRequest();
        sellRequest.setUserid("Jivaka");
        sellRequest.setPassword("Jivaka");
        sellRequest.setSymbol("mn");
        sellRequest.setQty(new java.math.BigInteger("50"));

        SellResponse sellResponse = traderStub.sell(sellRequest);
        assertNotNull(sellResponse);
        TradeStatus tradeStatus = sellResponse.getTrade_status();
        assertTrue(tradeStatus.getStatus());
        assertEquals(tradeStatus.getReason(), "Success");

    }

    public void testDoGetPortFolioWithoutQOS() throws Exception {
        GetPortfolioRequest getPortfolioRequest = new GetPortfolioRequest();
        getPortfolioRequest.setUserid("Jivaka");
        getPortfolioRequest.setPassword("Jivaka");

        GetPortfolioResponse getPortfolioResponse = traderStub.getPortfolio(getPortfolioRequest);
        assertNotNull(getPortfolioResponse);
        PortFolio portFolio = getPortfolioResponse.getPortFolio();
        PortFolioItem[] portFolioItems = portFolio.getPortFolioItem();
        assertNotNull(portFolioItems);
        assertEquals(portFolioItems[0].getAmount(), 50);
        assertEquals(portFolioItems[0].getSymbol(), "mn");

    }

    public void testDoGetMarketInfoWithoutQOS() throws Exception {
        GetInfoRequest getInfoRequest = new GetInfoRequest();

        GetInfoResponse getInfoResponse = exchangeStub.getInfo(getInfoRequest);

        assertNotNull(getInfoResponse);
        MarketInfo marketInfo = getInfoResponse.getMarketInfo();
        assertNotNull(marketInfo);

    }

}
