/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.sample.commodityquote;

import junit.framework.Assert;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.client.SequenceReport;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;
import org.wso2.wsas.sample.commodityquote.client.CommodityQuoteStub;
import org.wso2.wsas.sample.commodityquote.services.CommodityQuoteMessageReceiverInOut;
import org.wso2.www.types.client.*;

import javax.xml.namespace.QName;
import java.io.IOException;
import java.rmi.RemoteException;

public class CommodityQuoteServiceIntegrationT extends AbstractTestCase {

    private CommodityQuoteStub commodityQuoteClient;


    public void testDoGetQuoteWithoutQOS() throws Exception {
        this.checkResponseForGetQuoteWithSync();
    }


    public void testDoGetSymbolsWithoutQOS() throws Exception {
        this.checkResponseForGetSymbolsWithSync();
    }

    /*public void testDoGetQuoteWithRM() {
        try {
            this.configureRM();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        this.checkResponseForGetQuoteWithAsync();
    }

    public void testDoGetSymbolsWithRM() {
        try {
            this.configureRM();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        this.checkResponseForGetSymbolsWithAsync();
    }

    public void testDoGetQuoteWithSecure() {
        try {
            this.configureSecurity();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        this.checkResponseForGetQuoteWithSync();
    }

    public void testDoGetSymbolsWithSecure() {
        try {
            this.configureSecurity();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        this.checkResponseForGetSymbolsWithSync();
    }

    public void testDoGetQuoteWithSecureRM() {
        try {
            this.configureSecurity();
            this.configureRM();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        this.checkResponseForGetQuoteWithAsync();
    }

    public void testDoGetSymbolsWithSecureRM() {
        try {
            this.configureSecurity();
            this.configureRM();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        this.checkResponseForGetQuoteWithAsync();
    }*/


    private void configureRM() throws AxisFault, IOException {
        commodityQuoteClient._getServiceClient().engageModule(new QName("sandesha2"));
        commodityQuoteClient._getServiceClient().engageModule(new QName(
                org.apache.axis2.Constants.MODULE_ADDRESSING));

        Options clientOptions = commodityQuoteClient._getServiceClient().getOptions();

        clientOptions.setProperty("Sandesha2ClientAPIPropertyAcksTo",
                                  commodityQuoteClient._getServiceClient()
                                          .getMyEPR(Constants.TRANSPORT_HTTP)
                                          .getAddress());
        clientOptions.setProperty("Sandesha2ClientAPIPropertySequenceKey",
                                  UUIDGenerator.getUUID());

        clientOptions.setTransportInProtocol(Constants.TRANSPORT_HTTP);
        clientOptions.setUseSeparateListener(true);
        clientOptions
                .setProperty(SandeshaClientConstants.SANDESHA_LISTENER, new SandeshaListenerImpl());
    }

    private void configureSecurity() throws AxisFault, IOException {
        /*
TODO: fix compilation error

commodityQuoteClient._getServiceClient().engageModule(new QName("rampart"));

configurationContext.getAxisConfiguration()
.addParameter(WSS4JUtil.getEnableClientUsernameTokenParameter(
        "test"));

configurationContext.getAxisConfiguration()
.addParameter(WSS4JUtil.getClientUsernameTokenHandler(
        "test"));*/
    }


    private static class SandeshaListenerImpl implements SandeshaListener {
        public void onError(AxisFault fault) {
            System.out.println("ERROR:" + fault.getMessage());
        }

        public void onTimeOut(SequenceReport report) {
            System.out.println("ERROR: RM Sequence timed out");
        }
    }

    private void checkResponseForGetQuoteWithAsync() {
        GetQuoteRequest getQuoteRequest = new GetQuoteRequest();
        getQuoteRequest.setSymbol("mn");

        try {

            CommodityQuoteCallbackHandlerTestImpl callbackImpl =
                    new CommodityQuoteCallbackHandlerTestImpl();

            commodityQuoteClient.startgetQuote(getQuoteRequest, callbackImpl);

            while (!callbackImpl.isComplete()) {
                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    fail("Exeption" + e);
                }
            }

        } catch (RemoteException e) {
            fail("Exeption" + e);
        }
    }

    private void checkResponseForGetSymbolsWithAsync() {


        try {
            CommodityQuoteCallbackHandlerTestImpl callbackImpl =
                    new CommodityQuoteCallbackHandlerTestImpl();

            commodityQuoteClient.startgetSymbols(callbackImpl);

            while (!callbackImpl.isComplete()) {
                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    fail("Exeption" + e);
                }
            }

        } catch (RemoteException e) {
            fail("Exeption" + e);
        }
    }

    private void checkResponseForGetQuoteWithSync() throws Exception {

        try {
            String service = "http://" + NetworkUtils.getLocalHostname() + ":" +
                             TestConstants.TESTING_PORT +
                             "/" + ServerConstants.SERVICE_PATH +
                             "/CommodityQuote";
            EndpointReference epr = new EndpointReference(service);
            testConnect(epr);
            removeProperties();

            commodityQuoteClient = new CommodityQuoteStub(epr.getAddress());
        } catch (Exception e) {
            fail("Unexpected Exception " + e);
        }

        GetQuoteRequest getQuoteRequest = new GetQuoteRequest();
        getQuoteRequest.setSymbol("mn");

        GetQuoteResponse response;
        response = commodityQuoteClient.getQuote(getQuoteRequest);
        StockQuote stockQuote;
        stockQuote = response.getStockQuote();

        Assert.assertEquals(stockQuote.getName(), "mn");
        Assert.assertEquals(stockQuote.getSymbol(), "Manganese");

    }

    private void checkResponseForGetSymbolsWithSync() throws Exception {

        try {
            String service = "http://" + NetworkUtils.getLocalHostname() + ":" +
                             TestConstants.TESTING_PORT +
                             "/" + ServerConstants.SERVICE_PATH +
                             "/CommodityQuote";
            EndpointReference epr = new EndpointReference(service);
            testConnect(epr);
            removeProperties();
            commodityQuoteClient = new CommodityQuoteStub(epr.getAddress());
        } catch (Exception e) {
            fail("Unexpected Exception " + e);
        }

        GetSymbolsResponse response = null;

        response = commodityQuoteClient.getSymbols();

        ArrayOfString arr = response.get_return();
        String[] symbols = arr.getValue();
        assertEquals(symbols[0], "mn");
        assertEquals(symbols[1], "tm");

    }

}
