/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.sample.commodityquote;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.wso2.wsas.sample.commodityquote.client.CommodityQuoteCallbackHandler;
import org.wso2.www.types.client.ArrayOfString;
import org.wso2.www.types.client.GetQuoteResponse;
import org.wso2.www.types.client.GetSymbolsResponse;
import org.wso2.www.types.client.StockQuote;
/*
 * 
 */

public class CommodityQuoteCallbackHandlerTestImpl extends CommodityQuoteCallbackHandler {

    private boolean complete;

    public CommodityQuoteCallbackHandlerTestImpl() {
        super(null);
        complete = false;
    }

    public boolean isComplete() {
        return complete;
    }

    private void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void receiveResultgetQuote(GetQuoteResponse param21) {
        TestCase.assertNotNull(param21);
        StockQuote stockQuote = param21.getStockQuote();
        Assert.assertEquals(stockQuote.getSymbol(), "mn");
        Assert.assertEquals(stockQuote.getName(), "Manganese");
        setComplete(true);
    }

    public void receiveResultgetSymbols(GetSymbolsResponse param23) {
        TestCase.assertNotNull(param23);
        ArrayOfString symbols = param23.get_return();
        String[] symbolArr = symbols.getValue();
        TestCase.assertEquals(symbolArr[0], "mn");
        TestCase.assertEquals(symbolArr[1], "tm");
        setComplete(true);
    }

}
