/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.rest;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class RestWithSchemasT extends AbstractTestCase {

    QName serviceName = new QName("Calculator");
    QName operationName = new QName("add");
    private EndpointReference epr;


    protected void setUp() throws Exception {
        epr = new EndpointReference("http://" + NetworkUtils.getLocalHostname() + ":"
                                    + (TestConstants.TESTING_PORT)
                                    + "/" + ServerConstants.SERVICE_PATH + "/" + serviceName.getLocalPart() + "/" +
                                    operationName.getLocalPart());

        testConnect(epr);
        removeProperties();
    }

    public void testRESTGetInvocationWithAllParamsInURL() throws IOException {
        URL url = null;
        try {
            url = new URL(epr.getAddress());
        } catch (MalformedURLException e) {
            fail("Malformed EPR " + e);
        }
        NameValuePair[] nameValuePairs = new NameValuePair[3];
        nameValuePairs[0] = new NameValuePair("thirdNumber", "10");
        nameValuePairs[1] = new NameValuePair("firstNumber", "5");
        nameValuePairs[2] = new NameValuePair("secondNumber", "10");

        GetMethod getMethod = new GetMethod(url.toString());
        executeWithAllParamsInURL(url, nameValuePairs, getMethod);


        try {
            OMElement documentElement =
                    new StAXOMBuilder(getMethod.getResponseBodyAsStream()).getDocumentElement();
            documentElement.build();
            assertTrue("25".equals(documentElement.getFirstElement().getText()));
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void testRESTPostInvocationWithAllParamsInURL() throws IOException {
        URL url = null;
        try {
            url = new URL(epr.getAddress());
        } catch (MalformedURLException e) {
            fail("Malformed EPR " + e);
        }
        NameValuePair[] nameValuePairs = new NameValuePair[3];
        nameValuePairs[0] = new NameValuePair("thirdNumber", "10");
        nameValuePairs[1] = new NameValuePair("firstNumber", "5");
        nameValuePairs[2] = new NameValuePair("secondNumber", "10");

        PostMethod postMethod = new PostMethod(url.toString());
        executeWithAllParamsInURL(url, nameValuePairs, postMethod);

        try {
            OMElement documentElement =
                    new StAXOMBuilder(postMethod.getResponseBodyAsStream()).getDocumentElement();
            documentElement.build();
            assertTrue("25".equals(documentElement.getFirstElement().getText()));
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void testRESTPostInvocationWithAllParamsInBody() throws IOException {
        URL url = null;
        try {
            url = new URL(epr.getAddress());
        } catch (MalformedURLException e) {
            fail("Malformed EPR " + e);
        }
        NameValuePair[] NameValuePairs = new NameValuePair[3];
        NameValuePairs[0] = new NameValuePair("firstNumber", "10");
        NameValuePairs[1] = new NameValuePair("secondNumber", "5");
        NameValuePairs[2] = new NameValuePair("thirdNumber", "10");
        PostMethod postMethod = new PostMethod(url.toString());
        executePostWithAllParamsInBody(url, NameValuePairs, postMethod);

        try {
            OMElement documentElement =
                    new StAXOMBuilder(postMethod.getResponseBodyAsStream()).getDocumentElement();
            documentElement.build();
            assertTrue("25".equals(documentElement.getFirstElement().getText()));
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void testRESTPostInvocationWithParamsInUrlAndBody() throws IOException {
        URL url = null;
        try {
            url = new URL(epr.getAddress());
        } catch (MalformedURLException e) {
            fail("Malformed EPR " + e);
        }
        NameValuePair[] urlNameValuePairs = new NameValuePair[1];
        NameValuePair[] bodyNameValuePairs = new NameValuePair[2];
        urlNameValuePairs[0] = new NameValuePair("secondNumber", "10");
        bodyNameValuePairs[0] = new NameValuePair("firstNumber", "5");
        bodyNameValuePairs[1] = new NameValuePair("thirdNumber", "10");
        PostMethod postMethod = new PostMethod(url.toString());
        executePostWithParamsInUrlAndBody(url, urlNameValuePairs, bodyNameValuePairs, postMethod);

        try {
            OMElement documentElement =
                    new StAXOMBuilder(postMethod.getResponseBodyAsStream()).getDocumentElement();
            documentElement.build();
            assertTrue("25".equals(documentElement.getFirstElement().getText()));
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void testRESTPostInvocationAsTextXML() {
        URL url = null;
        try {
            url = new URL(epr.getAddress());
        } catch (MalformedURLException e) {
            fail("Malformed EPR " + e);
        }

        String xml =
                "<ns:add xmlns:ns=\"http://org.apache.axis2/xsd\">" +
                "<ns:firstNumber>10</ns:firstNumber>" +
                "<ns:secondNumber>5</ns:secondNumber>" +
                "<ns:thirdNumber>10</ns:thirdNumber>" +
                "</ns:add>";

        byte arr[] = xml.getBytes();

        ByteArrayInputStream bais = new ByteArrayInputStream(arr);

        XMLStreamReader reader = null;
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            reader = xif.createXMLStreamReader(bais);
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement postData = builder.getDocumentElement();

        PostMethod postMethod = new PostMethod(url.toString());
        postMethod.setPath(url.getPath());
        postMethod.
                setRequestEntity(new RESTPostRequestEntity(postData,
                                                           ServerConstants.HTTPConstants.MEDIA_TYPE_APPLICATION_XML));
        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod(postMethod);
        } catch (IOException e) {
            e.printStackTrace();
        }

        XMLStreamReader pareser = null;
        try {
            pareser = XMLInputFactory.newInstance().
                    createXMLStreamReader(postMethod.getResponseBodyAsStream());
        } catch (XMLStreamException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        StAXOMBuilder responseBuilder = new StAXOMBuilder(pareser);
        OMElement responseElement = responseBuilder.getDocumentElement();
        responseElement.build();


        assertTrue("25".equals(responseElement.getFirstElement().getText()));
    }

    private HttpMethodBase executeWithAllParamsInURL(URL url,
                                                     NameValuePair[] nameValuePairs,
                                                     HttpMethodBase method) {
        method.setPath(url.getPath());
        method.setQueryString(nameValuePairs);
        method.setRequestHeader(HTTPConstants.HEADER_CONTENT_TYPE,
                                ServerConstants.HTTPConstants.MEDIA_TYPE_X_WWW_FORM);

        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod(method);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return method;

    }

    private PostMethod executePostWithParamsInUrlAndBody(URL url,
                                                         NameValuePair[] urlNameValuePairs,
                                                         NameValuePair[] bodyNameValuePairs,
                                                         PostMethod postMethod) {
        postMethod.setPath(url.getPath());
        postMethod.setQueryString(urlNameValuePairs);
        postMethod.setRequestBody(bodyNameValuePairs);
        postMethod.setRequestHeader(HTTPConstants.HEADER_CONTENT_TYPE,
                                    ServerConstants.HTTPConstants.MEDIA_TYPE_X_WWW_FORM);

        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod(postMethod);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return postMethod;
    }

    private PostMethod executePostWithAllParamsInBody(URL url,
                                                      NameValuePair[] nameValuePairs,
                                                      PostMethod postMethod) {
        postMethod.setPath(url.getPath());
        postMethod.setRequestBody(nameValuePairs);
        postMethod.setRequestHeader(HTTPConstants.HEADER_CONTENT_TYPE,
                                    ServerConstants.HTTPConstants.MEDIA_TYPE_X_WWW_FORM);

        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod(postMethod);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return postMethod;
    }

    public static class RESTPostRequestEntity implements RequestEntity {
        private String contentType;
        private OMElement postRequestBody;
        private byte[] bytes;

        public RESTPostRequestEntity(OMElement postRequestBody, String contentType) {
            this.postRequestBody = postRequestBody;
            this.contentType = contentType;
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream out) throws IOException {
            if (bytes == null)

            {
                try {
                    bytes = writeBytes();
                } catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }

            out.write(bytes);
            out.flush();
        }

        public long getContentLength() {
            if (bytes == null) {
                try {
                    bytes = writeBytes();
                } catch (AxisFault axisFault) {
                    axisFault.printStackTrace();
                } catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }

            return bytes.length;
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] writeBytes() throws AxisFault, XMLStreamException {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            OMOutputFormat format = new OMOutputFormat();
            postRequestBody.serializeAndConsume(bytesOut, format);

            return bytesOut.toByteArray();

        }
    }
}

