/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.rest;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HTTPConstants;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class RestSupportT extends AbstractTestCase {

    QName serviceName = new QName("Calculator");
    QName operationName = new QName("add");
    private EndpointReference epr;


    protected void setUp() throws Exception {

        epr = new EndpointReference("http://" + NetworkUtils.getLocalHostname() + ":"
                                    + (TestConstants.TESTING_PORT)
                                    + "/" + ServerConstants.SERVICE_PATH + "/" + serviceName.getLocalPart() + "/" +
                                    operationName.getLocalPart());
        testConnect(epr);
        removeProperties();

    }


    public void testRESTGetInvocationWithAllParamsInURL() throws IOException {
        OMElement data = getRequestOMElement();

        Options options = new Options();
        options.setTo(epr);
        options.setProperty(HTTPConstants.CHUNKED, Boolean.FALSE);
        options.setTransportInProtocol(org.apache.axis2.Constants.TRANSPORT_HTTP);
        options.setProperty(org.apache.axis2.Constants.Configuration.MESSAGE_TYPE,
                            ServerConstants.HTTPConstants.MEDIA_TYPE_X_WWW_FORM);
        options.setProperty(org.apache.axis2.Constants.Configuration.HTTP_METHOD,
                            org.apache.axis2.Constants.Configuration.HTTP_METHOD_GET);
        options.setProperty(org.apache.axis2.Constants.Configuration.ENABLE_REST, Boolean.TRUE);
        ServiceClient sender =
                new ServiceClient(ConfigurationContextFactory.
                        createConfigurationContextFromFileSystem(null, null), null);
        sender.setOptions(options);
        options.setTimeOutInMilliSeconds(100000000);
        OMElement response = sender.sendReceive(data);
        response.build();

        assertTrue("25".equals(response.getFirstElement().getText()));
    }

    public void testRESTPostInvocationWithAllParamsInUrl() throws IOException {
        OMElement data = getRequestOMElement();

        Options options = new Options();
        options.setTo(epr);
        options.setProperty(HTTPConstants.CHUNKED, Boolean.FALSE);
        options.setTransportInProtocol(org.apache.axis2.Constants.TRANSPORT_HTTP);
        options.setProperty(org.apache.axis2.Constants.Configuration.MESSAGE_TYPE,
                            ServerConstants.HTTPConstants.MEDIA_TYPE_X_WWW_FORM);
        options.setProperty(
                org.apache.axis2.Constants.Configuration.HTTP_METHOD,
                org.apache.axis2.Constants.Configuration.HTTP_METHOD_POST);

        options.setProperty(
                org.apache.axis2.Constants.Configuration.URL_PARAMETER_LIST,
                new String[]{"firstNumber", "secondNumber", "thirdNumber"});
        options.setProperty(org.apache.axis2.Constants.Configuration.ENABLE_REST,
                            Boolean.TRUE);

        ServiceClient sender =
                new ServiceClient(ConfigurationContextFactory.
                        createConfigurationContextFromFileSystem(null, null), null);
        sender.setOptions(options);
        options.setTimeOutInMilliSeconds(100000000);
        OMElement response = sender.sendReceive(data);
        response.build();

        assertTrue("25".equals(response.getFirstElement().getText()));
    }

    public void testRESTPostInvocationWithAllParamsInBody() throws IOException {
        OMElement data = getRequestOMElement();

        Options options = new Options();
        options.setTo(epr);
        options.setProperty(HTTPConstants.CHUNKED, Boolean.FALSE);
        options.setTransportInProtocol(org.apache.axis2.Constants.TRANSPORT_HTTP);
        options.setProperty(org.apache.axis2.Constants.Configuration.MESSAGE_TYPE,
                            ServerConstants.HTTPConstants.MEDIA_TYPE_X_WWW_FORM);
        options.setProperty(
                org.apache.axis2.Constants.Configuration.HTTP_METHOD,
                org.apache.axis2.Constants.Configuration.HTTP_METHOD_POST);
        options.setProperty(org.apache.axis2.Constants.Configuration.ENABLE_REST,
                            Boolean.TRUE);

        ServiceClient sender =
                new ServiceClient(ConfigurationContextFactory.
                        createConfigurationContextFromFileSystem(null, null), null);
        sender.setOptions(options);
        options.setTimeOutInMilliSeconds(10000000);
        OMElement response = sender.sendReceive(data);
        response.build();

        assertTrue("25".equals(response.getFirstElement().getText()));
    }

    /*public void testRESTPostInvocationWithParamsInUrlAndBody() throws IOException {
        OMElement data = getRequestOMElement();

        Options options = new Options();
        options.setTo(epr);
        options.setProperty(HTTPConstants.CHUNKED, Boolean.FALSE);
        options.setTransportInProtocol(org.apache.axis2.Constants.TRANSPORT_HTTP);
        options.setProperty(org.apache.axis2.Constants.Configuration.MESSAGE_TYPE,
                            ServerConstants.HTTPConstants.MEDIA_TYPE_X_WWW_FORM);
        options.setProperty(
                org.apache.axis2.Constants.Configuration.HTTP_METHOD,
                org.apache.axis2.Constants.Configuration.HTTP_METHOD_POST);

        options.setProperty(
                org.apache.axis2.Constants.Configuration.URL_PARAMETER_LIST,
                new String[]{"firstNumber", "secondNumber"});
        options.setProperty(org.apache.axis2.Constants.Configuration.ENABLE_REST,
                            Boolean.TRUE);

        ServiceClient sender =
                new ServiceClient(ConfigurationContextFactory.
                        createConfigurationContextFromFileSystem(null, null), null);
        sender.setOptions(options);
        OMElement response = sender.sendReceive(data);
        response.build();

        assertTrue("25".equals(response.getFirstElement().getText()));
    }

    public void testRESTPostInvocationAsTextXML() throws IOException, XMLStreamException {
        OMElement data = getRequestOMElement();

        Options options = new Options();
        options.setTo(epr);
        options.setProperty(HTTPConstants.CHUNKED, Boolean.FALSE);
        options.setTransportInProtocol(org.apache.axis2.Constants.TRANSPORT_HTTP);
        options.setProperty(HTTPConstants.HEADER_CONTENT_TYPE,
                            ServerConstants.HTTPConstants.MEDIA_TYPE_APPLICATION_XML);
        options.setProperty(org.apache.axis2.Constants.Configuration.HTTP_METHOD,
                            org.apache.axis2.Constants.Configuration.HTTP_METHOD_POST);
        options.setProperty(org.apache.axis2.Constants.Configuration.ENABLE_REST,
                            Boolean.TRUE);

        ServiceClient sender =
                new ServiceClient(ConfigurationContextFactory.
                        createConfigurationContextFromFileSystem(null, null), null);
        sender.setOptions(options);
        OMElement response = sender.sendReceive(data);
        response.build();

        assertTrue("25".equals(response.getFirstElement().getText()));

    }*/
    public OMElement getRequestOMElement() {
        String xml =
                "<ns:add xmlns:ns=\"http://org.apache.axis2/xsd\">" +
                "<ns:secondNumber>10</ns:secondNumber>" +
                "<ns:firstNumber>5</ns:firstNumber>" +
                "<ns:thirdNumber>10</ns:thirdNumber>" +
                "</ns:add>";

        byte arr[] = xml.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(arr);

        XMLStreamReader reader = null;
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            reader = xif.createXMLStreamReader(bais);
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement data = builder.getDocumentElement();
        data.build();
        return data;
    }
}

