/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.tracer.service;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.WSDL2Constants;
import org.wso2.tracer.TracerConstants;
import org.wso2.utils.CircularBuffer;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.*;
import org.wso2.wsas.persistence.exception.ServiceAlreadyExistsException;
import org.wso2.wsas.util.HibernateConfig;
import org.wso2.wsas.util.HibernateConfigFactory;
import org.wso2.wsas.util.ServerUtils;

import javax.xml.namespace.QName;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.HashMap;


/**
 * TODO Find a way to fix this test case
 */
public class TracerServiceIntegrationTest extends AbstractTestCase {
    private QName serviceName;
    private PersistenceManager persistenceMgr;

    /*protected void setUp() {
        try {
//            ServerConfiguration.configurationXMLLocation = "../standalone-edition/conf/server.xml";
            super.setUp();

            HibernateConfig hbConfig =
                    HibernateConfigFactory.getDefaultConfig(ServerConstants.WSO2WSAS_HB_CONFIG_KEY);
            persistenceMgr = new PersistenceManager();
            serviceName = new QName("TracerService");

            ConfigurationContext configContext = null;
            CircularBuffer circularBuffer = new CircularBuffer();

            for (int i = 0; i < 4; i++) {
                circularBuffer.append(getMessageSummary("TestService",
                                                        "doOperation", 1000 + i));
            }

            configContext.setProperty(TracerConstants.MSG_SEQ_BUFFER, circularBuffer);
            Map mrMap = new HashMap();
            mrMap.put(WSDL2Constants.MEP_URI_IN_OUT, new Wso2TracerMessageReceiverInOut());
            ServerUtils.deployService(configContext,
                                      TracerService.class.getName(),
                                      mrMap);
        } catch (Exception e) {
            fail("Unexpected Exception " + e);
        }
    }

    private MessageSummary getMessageSummary(String serviceId,
                                             String opName,
                                             long msgSeq) {
        MessageSummary msgSummary = new MessageSummary();
        msgSummary.setServiceId(serviceId);
        msgSummary.setOperationName(opName);
        msgSummary.setMessageSequence(msgSeq);

        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        msgSummary.setTimestamp(cal);

        return msgSummary;
    }

    public void testGetLastMessages() {
        QName operationName = new QName("getLastMessages");

        try {
            Wso2TracerStub client = new Wso2TracerStub("http://" +
                                                             NetworkUtils.getLocalHostname() + ":" +
                                                             (TestConstants.TESTING_PORT) +
                                                             "/"+ ServerConstants.SERVICE_PATH +"/" +
                                                             serviceName.getLocalPart() + "/" +
                                                             operationName.getLocalPart());
            Wso2TracerStub.GetLastMessagesRequest req =
                    new Wso2TracerStub.GetLastMessagesRequest();
            req.setMessages(10);

            TracerServiceStub.GetLastMessagesResponse lastMessages =
                    client.getLastMessages(req);
            TracerServiceStub.MessageSummary[] msgSummaries = lastMessages.getMessages();

            for (int i = 0; i < msgSummaries.length; i++) {
                assertEquals("TestService", msgSummaries[i].getServiceId());
                assertEquals("doOperation", msgSummaries[i].getOperationName());
                assertEquals(1000 + i, msgSummaries[i].getMessageSequence());
            }
        } catch (Exception e) {
            e.printStackTrace();
            fail("Unexpected Exception " + e);
        }
    }

    public void testGetMessage() {
        QName operationName = new QName("getMessage");

        try {
            TracerServiceStub client = new TracerServiceStub("http://" +
                                                             NetworkUtils.getLocalHostname() + ":" +
                                                             (TestConstants.TESTING_PORT) +
                                                             "/"+ ServerConstants.SERVICE_PATH +"/" +
                                                             serviceName.getLocalPart() + "/" +
                                                             operationName.getLocalPart());
            client._getServiceClient().getOptions().setTimeOutInMilliSeconds(1000000);

            long timestamp = System.currentTimeMillis();
            addMessageToDB(timestamp);

            TracerServiceStub.GetMessageRequest req =
                    new TracerServiceStub.GetMessageRequest();
            req.setMessageSequence(0);
            req.setOperationName("doOperation");
            req.setServiceId("TestService" + timestamp);

            TracerServiceStub.GetMessageResponse resp =
                    client.getMessage(req);

            assertEquals("<hello>Hi_Request</hello>", resp.getReceivedMessage());
            assertEquals("<hello>Hi_Response</hello>", resp.getSentMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail("Unexpected Exception " + e);
        }
    }

    private void addMessageToDB(long timestamp) {
        ServiceGroupDO sgDO = new ServiceGroupDO();
        sgDO.setName("test-sg-" + System.currentTimeMillis());
        persistenceMgr.addServiceGroup(sgDO);

        ServiceDO service = new ServiceDO();
        service.setServiceGroup(sgDO);
        ServiceIdentifierDO id = new ServiceIdentifierDO();
        String serviceId = "TestService" + timestamp;
        id.setServiceId(serviceId);

        String version = ServiceIdentifierDO.EMPTY_SERVICE_VERSION;
        id.setVersion(version);
        service.setServiceIdentifierDO(id);

        OperationDO operation = new OperationDO();
        String opName = "doOperation";
        operation.setName(opName);
        service.addOperation(operation);

        try {
            persistenceMgr.addService(service);
        } catch (ServiceAlreadyExistsException e) {
            e.printStackTrace();
            fail("Unexpected Exception " + e);
        }

        assertNotNull(persistenceMgr.getService(serviceId, version));
        addMessageToDB(MessageContext.IN_FLOW, "<hello>Hi_Request</hello>",
                       serviceId, version, operation.getName());
        addMessageToDB(MessageContext.OUT_FLOW, "<hello>Hi_Response</hello>",
                       serviceId, version, operation.getName());

        MessageDO msg = new MessageDO(serviceId, version, opName);
        MessageDO[] messages = persistenceMgr.getMessages(msg);
        assertEquals(2, messages.length);
    }

    private void addMessageToDB(int flow, String xml, String serviceId,
                                String version, String opName) {
        MessageDO message = new MessageDO();
        message.setType(flow);
        message.setSequence(0);
        message.setServiceId(serviceId);
        message.setServiceVersion(version);
        message.setXml(xml);
        message.setOperationName(opName);

        persistenceMgr.addMessage(message);
    }*/
}
