/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.documentation;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DocLinkT extends AbstractTestCase {

    private static Log log = LogFactory.getLog(DocLinkT.class);

    public void testAllLinks() throws Exception {

        EndpointReference epr =
                new EndpointReference("http://" + NetworkUtils.getLocalHostname() + ":" +
                                      TestConstants.TESTING_PORT +
                                      "/" + ServerConstants.SERVICE_PATH +
                                      "/echo");

        testConnect(epr);

        List chekedList = new ArrayList();
        List errorList = new ArrayList();
        List externelList = new ArrayList();
        WebConversation wc = new WebConversation();
        LinkInfo linkInfo = new LinkInfo("index.html");
        try {
            String baseURL = "http://localhost:39762/test_docs/";
            WebResponse index = wc.getResponse(baseURL);
            followLinks(index, baseURL, chekedList, errorList, externelList);
        } catch (IOException e) {
            linkInfo.setLink("-");
            linkInfo.setDescription("IOException");
            errorList.add(linkInfo);
        } catch (SAXException e) {
            linkInfo.setLink("-");
            linkInfo.setDescription("SAXException");
            errorList.add(linkInfo);
        }

        printInfo(errorList);

    }

    private void followLinks(WebResponse parentResponse, String baseURL,
                             List chekedList,
                             List errorList,
                             List externelList) {

        WebLink[] webLinks;
        try {
            webLinks = parentResponse.getLinks();
        } catch (SAXException e) {
            LinkInfo linkInfo = new LinkInfo(parentResponse.getURL().toString());
            linkInfo.setLink(parentResponse.getURL().toString());
            linkInfo.setDescription("SAXException");
            errorList.add(linkInfo);
            return;
        }
        List webLinkList = Arrays.asList(webLinks);
        for (Iterator iterator = webLinkList.iterator(); iterator.hasNext();) {
            WebLink webLink = (WebLink) iterator.next();
            String urlString = webLink.getURLString();
            LinkInfo linkInfo = new LinkInfo(parentResponse.getURL().toString());
            linkInfo.setLink(urlString);
            linkInfo.setText(webLink.getText());
            if (chekedList.contains(urlString) || errorList.contains(urlString) ||
                externelList.contains(urlString)) {
                continue;
            }
            if (urlString.indexOf("http://") > -1 && (urlString.indexOf("http://localhost") < 0)) {
                linkInfo.setDescription("Found an external link [Ignore]");
                externelList.add(linkInfo);
                continue;
            }
            if (urlString.indexOf("www.") > -1) {
                linkInfo.setDescription("Found an external link [Ignore]");
                externelList.add(linkInfo);
                continue;

            }
            if (urlString.indexOf("apidocs") > -1) {
                linkInfo.setDescription("Found API docs");
                externelList.add(linkInfo);
                continue;
            }

            if (urlString.indexOf("http://") < 0) {
                urlString = baseURL + urlString;
                linkInfo.setLink(urlString);
            }

            if (chekedList.contains(urlString) || errorList.contains(urlString)) {
                continue;
            }
            WebResponse response = null;
            try {
//                System.out.println("Following the new link : " + urlString);
                response = webLink.click();
            } catch (UnknownHostException e) {
                // TODO Ingnor it for the moment
            } catch (IOException e) {
                linkInfo.setLink(urlString);
                linkInfo.setDescription("IOException");
                errorList.add(linkInfo);
                continue;
            } catch (SAXException e) {
                linkInfo.setLink(urlString);
                linkInfo.setDescription("SAXException");
                errorList.add(linkInfo);
                continue;
            } catch (RuntimeException e) {
                linkInfo.setLink(urlString);
                linkInfo.setDescription("RuntimeException");
                errorList.add(linkInfo);
                continue;
            }
            chekedList.add(urlString);
            if (response != null) {
                followLinks(response, baseURL, chekedList, errorList, externelList);
            }
        }

    }

    private void printInfo(List list) {
        log.info("------------------------------------------------------------------------------------------------------------------------------");
        log.info("             File Name              |           Text                |              Link in Question     |      Description    ");
        log.info("------------------------------------------------------------------------------------------------------------------------------");
        int i = 1;
        for (Iterator iterator = list.iterator(); iterator.hasNext();) {
            LinkInfo linkInfo = (LinkInfo) iterator.next();
            if (linkInfo.getDescription().equals("RuntimeException")) {
                log.info(" [ " + i + " ]   " + linkInfo.getFileName() + "      |        "+ linkInfo.getText()+"      |       " +  linkInfo.getLink() + "       |         " + linkInfo.getDescription());
                log.info("--------------------------------------------------------------------------------------------------------------");
                i++;
            }
        }
    }
    
}
