/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.codegen.service.java;

import org.apache.axis2.addressing.EndpointReference;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;

import javax.xml.namespace.QName;
import java.rmi.RemoteException;


/**
 *
 */
public class JavaClientGeneratorServiceT extends AbstractTestCase {
    private JavaClientGeneratorServiceStub client;
    private QName serviceName = new QName("JavaClientGeneratorService");

    protected void setUp() throws Exception {


        String s = "http://" +
                   NetworkUtils.getLocalHostname() + ":" +
                   (TestConstants.TESTING_PORT) +
                   "/" + ServerConstants.SERVICE_PATH + "/" +
                   serviceName.getLocalPart();
        EndpointReference epr = new EndpointReference(s);
        testConnect(epr);
        removeProperties();
        client = new JavaClientGeneratorServiceStub(s);
        client._getServiceClient().getOptions().setTimeOutInMilliSeconds(120000);

    }

    private JavaClientGeneratorServiceStub.Generate _generateRequest(String databind,
                                                                     String invocationStyle) {
        JavaClientGeneratorServiceStub.Generate req = new JavaClientGeneratorServiceStub.Generate();
        req.setService("Version");
        req.setPackageName("org.wso2.wsas.wsdl2code");
        req.setInvocationStyle(invocationStyle);
        req.setGenerateTestCase(false);
        req.setDatabindingMethod(databind);
        req.setUnpackClasses(true);
        req.setServiceBindingName("");
        req.setServicePortName("");

        return req;
    }

    public void testGenerateSync() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp =
                    client.generate(_generateRequest("adb", "s"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            e.printStackTrace();
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateAsync() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp =
                    client.generate(_generateRequest("none", "a"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateAsyncXMLBeans() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp = client.generate(_generateRequest(
                    "xmlbeans", "a"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateSyncXMLBeans() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp = client.generate(_generateRequest(
                    "xmlbeans", "s"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateDefaultXMLBeans() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp = client.generate(_generateRequest(
                    "xmlbeans", "sa"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateAsyncADB() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp =
                    client.generate(_generateRequest("adb", "a"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateSyncADB() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp =
                    client.generate(_generateRequest("adb", "s"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateDefaultADB() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp =
                    client.generate(_generateRequest("adb", "sa"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerate() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp =
                    client.generate(_generateRequest("none",
                                                     "sa"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            e.printStackTrace();
            fail("Unexpected Exception : " + e);
        }
    }

    public void testGenerateWithTestCase() {
        try {
            JavaClientGeneratorServiceStub.GenerateResponse resp =
                    client.generate(_generateRequest("none",
                                                     "sa"));
            assertNotNull(resp);
            System.out.println("Response=" + resp.get_return());
        } catch (RemoteException e) {
            fail("Unexpected Exception : " + e);
        }
    }
}
