/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.codegen.service;

import org.apache.axis2.addressing.EndpointReference;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;

public class WSDLInfoServiceT extends AbstractTestCase {

    EndpointReference epr;

    public void setUp() throws java.lang.Exception {
        epr = new EndpointReference("http://" +
                                    NetworkUtils.getLocalHostname() + ":" +
                                    (TestConstants.TESTING_PORT) +
                                    "/" + ServerConstants.SERVICE_PATH + "/" +
                                    "WSDLInfoService");
        testConnect(epr);
        removeProperties();
    }

    public void testListServicesAndPortsWSDL11() throws Exception {
        WSDLInfoServiceStub client = new WSDLInfoServiceStub(null, epr.getAddress());

        WSDLInfoServiceStub.ListServicesAndPorts req =
                new WSDLInfoServiceStub.ListServicesAndPorts();
        WSDLInfoServiceStub.WSDLRestriction wsdlRestriction =
                WSDLInfoServiceStub.WSDLRestriction.value1;
        req.setServiceName("WSDLInfoService");
        req.setWsdlVersion(wsdlRestriction);
        req.setWsdlLocation(epr.getAddress() + "?wsdl");
        client._getServiceClient().getOptions().setTimeOutInMilliSeconds(1000000);

        WSDLInfoServiceStub.ListServicesAndPortsResponse response =
                client.listServicesAndPorts(req);
        assertNotNull(response);
    }

    public void testtestListServicesAndPortsWSDL12() throws Exception {
        WSDLInfoServiceStub client = new WSDLInfoServiceStub(null, epr.getAddress());

        WSDLInfoServiceStub.ListServicesAndPorts req =
                new WSDLInfoServiceStub.ListServicesAndPorts();
        WSDLInfoServiceStub.WSDLRestriction wsdlRestriction =
                WSDLInfoServiceStub.WSDLRestriction.value2;
        req.setServiceName("WSDLInfoService");
        req.setWsdlVersion(wsdlRestriction);
        req.setWsdlLocation(epr.getAddress() +"?wsdl2");
        client._getServiceClient().getOptions().setTimeOutInMilliSeconds(1000000);

        WSDLInfoServiceStub.ListServicesAndPortsResponse response =
                client.listServicesAndPorts(req);
        assertNotNull(response);
    }
}
